
    rm(list=ls(all=TRUE))

    setwd("C:/jordi/EEZA_2013/mini-Akira/debug")
    getwd()


    trait_vals<-read.table("trait_ranges2_sw.txt",header=T)
    trait_limits<-read.table("trait_limits.txt",header=T)
    switches<-read.table("switches_T_range2.txt",header=T)

    setwd("C:/jordi/EEZA_2013/mini-Akira/debug/XXX_2")
    getwd()

    ####################################################################################################################
    ####################################################################################################################
    #### LIBRARIES, GLOBAL FUNCTIONS AND CONSTANTS ####


              ###this file should be set with the values we want for the simulation (see "read_me_switches.xls" for explanation)

    conventional_order=switches$conventional_order
    autocor=switches$autocor
    prey_integration=switches$prey_integration
    pred_integration=switches$pred_integration
    prey_mod_int_1=as.character(switches$prey_mod_int_1) ##"only_mean"	"max_int"
    prey_mod_int_2=as.character(switches$prey_mod_int_2) ##"only_mean"	"max_int"
    prey_mod_int_3=as.character(switches$prey_mod_int_3) ##"only_mean"	"max_int"
    prey_mod_int_4=as.character(switches$prey_mod_int_4) ##"only_mean"	"max_int"
    predators=switches$predators
    pred_mod_int_1=as.character(switches$pred_mod_int_1) ##"only_mean"	"max_int"
    pred_mod_int_2=as.character(switches$pred_mod_int_2) ##"only_mean"	"max_int"
    pred_mod_int_3=as.character(switches$pred_mod_int_3) ##"only_mean"	"max_int"
    pred_mod_int_4=as.character(switches$pred_mod_int_4) ##"only_mean"	"max_int"
    rho_prey=switches$rho_prey
    rho_pred=switches$rho_pred
    n_loci=switches$n_loci
    n_alleles=switches$n_alleles
    T=switches$T1
    restrict=switches$restrict
    adaptive=switches$adaptive
    mode=as.character(switches$mode)


    steps=as.integer(switches$steps)            ##number of days for the simulation

    ####TROPHIC CASCADE COLLECTOR##############
    ###########################################
    TC<-as.data.frame(matrix(nrow=steps,ncol=13))       ##this just collects the information on how fungi biomass changes from day to day
    names(TC)[1:13]<-c("BIOMASS","BIOMASS_OUT","PREY_EGGS","PREY_ALIVE","PREY_STARVED","PREY_PREDATED",
    "PREY_SENESCED","PREY_BMSS_OUT","PRED_EGGS","PRED_ALIVE","PRED_STARVED","PRED_PREDATED","PRED_SENESCED")



    #global functions
    interpol<-function(x,miny,maxy)    ##interpolation for vectors
    {
    y=miny+((x-min(x))*((maxy-miny)/(max(x)-min(x))))
    return(y)
    }

    interpol2<-function(x,minx,maxx,miny,maxy)  ##interpolation for values
    {
    y=miny+((x-minx)*((maxy-miny)/(maxx-minx)))
    return(y)
    }

     ############### CONSTANTS - NONE SHOULD BE CHANGED - MAKES THE ENTIRE THING WORK REALISTICALLY ##############
    max_T=25         ##maximum temperature at which simulations are performed
    min_T=15         ##minimum temperature at which simulations are performed
    max_rep_prey=2   ###prey die after 2 reproductive events
    max_rep_pred=5   ###pred die after 5 reproductive events

    Q10pheno=0.35     ##phenology/egg time development shortening with an increase in 10C
    Q10digest=0.25    ##digestion time shortening with an increase in 10C

    deadly_tank=0.1   ##determines death from starvation

    upper_tank_pred=2.4  ##changed from detailed calculations in logistic_and_min_max_values_for_intepol_EVOLUTIONARY_LIMITS.xls
    upper_tank_prey=2.3

    min_K=0.1
    max_K=switches$max_K
    K=max_K
    min_fungi=0.99*min_K  ##mg   ###The simulation starts close to carrying capacity in fungi biomass / this can be actually part of the O matrix
    max_fungi=0.99*max_K

    min_r=exp(25.98-(0.68*(1/(0.0000862*(T+273.15)))))/((min_fungi*1000)^(1/4))  ##ind/indxday | Fig. 4 in Savage et al. 2004 Am. Nat.
    max_r=exp(25.98-(0.68*(1/(0.0000862*(T+273.15)))))/((max_fungi*1000)^(1/4))  ###it is a lower r when mass is larger

    zero_fungi=8#biomass<min_fungi/zero_fungi #criterion to consider fungi extinction in a cell
    assigned=0.9 ###proportion of total mass which is invested in growth

    max_encs_T=4 ##calculated with 4X pred and highest temperature=25C gives 4... thus after removing Q10 gives 1
    max_search_area=4
    max_search_area_T=9

    ###the following parameters are newly added to standardize the predictors in encounter and predation probabilities (file: trait_parameterization...xls)
    mean_size_pred= 0.376
    sd_size_pred=   0.13
    mean_size_prey= 0.223
    sd_size_prey=   0.07
    mean_vor_pred=  0.298
    sd_vor_pred=    0.1
    mean_vor_prey=  0.171
    sd_vor_prey=    0.06
    mean_spd_pred=  8.02
    sd_spd_pred=    2.8
    mean_spd_prey=  6.3
    sd_spd_prey=    2.1
    mean_size_x_size=  0.298
    sd_size_x_size=    0.1
    mean_vor_x_vor=    0.178
    sd_vor_x_vor=      0.06
    mean_spd_ratio=    39
    sd_spd_ratio=      14
    mean_size_ratio=   19.28
    sd_size_ratio=     6.9
    mean_search_area_pred=9.85
    sd_search_area_pred=3.3


    min_p_encounter=0.503
    max_p_encounter=0.938
    min_p_predation=0.528
    pseudo_min_p_predation=0.3
    max_p_predation=0.895

    max_voracity_prey_T=0.3422   ###these figures change with max vorQ10 - currently in file trait_parameterization_spider_plus_collembola.xls
    max_voracity_pred_T=0.5965

    tunea_background=0.1   ##to be sure that predators have background mortality but this is not too high

     tunea_enc_rate_low=0.70    #maximum value for interpolation
#    tunea_enc_rate_high=0.7    #maximum value for interpolation

     tunea_pred_rate=0.70   ##maximum value for interpolation

    keep_for_surv_prey=1.2 ###when reproducing, they keep 1.1 as much energy as the minimum for survival (i.e., that which determines the deadly tank). Otherwise investment in reproduction is terminal.
    keep_for_surv_pred=3
    safe_starv_prey=1.2
    safe_starv_pred=3
    
    control_attack_rate=0.0

    ########## TRAIT RANGES (WE WORK WITH 13 TRAITS WHICH HAVE GENETIC VARIABILITY AND CORRELATION AMONG THEM VARIES - G MATRIX) ################
    #########################################################################################################################

    trait_names<-c("energy_tank","voracity","speed","body_size","met_rate","growth","search_area"
    ,"assim","pheno","vorQ10","spdQ10","srchQ10","actE_met")

    trait_vals$trait<-as.character(trait_vals$trait)

    middles<-as.data.frame(matrix(nrow=nrow(trait_vals),ncol=2))

    names(middles)<-c("mid_prey","mid_pred")

    middles$mid_prey<-(trait_vals[,c(3)]-trait_vals[,c(2)])/2
    middles$mid_pred<-(trait_vals[,c(5)]-trait_vals[,c(4)])/2

    print(trait_vals)
    trait_vals[,c(2)]<-trait_vals[,c(2)]+middles$mid_prey*restrict
    trait_vals[,c(3)]<-trait_vals[,c(3)]-middles$mid_prey*restrict
    trait_vals[,c(4)]<-trait_vals[,c(4)]+middles$mid_pred*restrict
    trait_vals[,c(5)]<-trait_vals[,c(5)]-middles$mid_pred*restrict
    print(trait_vals)



    trait_limits$trait<-as.character(trait_limits$trait)


    trait_vals$naive_min_prey<-matrix(nrow=nrow(trait_vals),ncol=1)
    trait_vals$naive_max_prey<-matrix(nrow=nrow(trait_vals),ncol=1)
    trait_vals$naive_min_pred<-matrix(nrow=nrow(trait_vals),ncol=1)
    trait_vals$naive_max_pred<-matrix(nrow=nrow(trait_vals),ncol=1)

    #conventional initial assignment of traits to modules
    if (conventional_order==1){
    mod1_1=1       ##1
    mod1_2=6       ##6
    mod1_3=9       ##9
    mod2_1=3
    mod2_2=5
    mod2_3=7
    mod3_1=4
    mod3_2=8
    mod3_3=2
    mod4_1=10      ##10
    mod4_2=11      ##11
    mod4_3=12      ##12
    }

    ##randomly assigning traits to modules
    if (conventional_order==0){
    capta<-as.integer(1:12)
    x<-runif(12)
    both<-data.frame(capta,x)
    orden_aleat<-both[do.call(order,both[c("x")]),]

    mod1_1=orden_aleat[1,1]
    mod1_2=orden_aleat[2,1]
    mod1_3=orden_aleat[3,1]
    mod2_1=orden_aleat[4,1]
    mod2_2=orden_aleat[5,1]
    mod2_3=orden_aleat[6,1]
    mod3_1=orden_aleat[7,1]
    mod3_2=orden_aleat[8,1]
    mod3_3=orden_aleat[9,1]
    mod4_1=orden_aleat[10,1]
    mod4_2=orden_aleat[11,1]
    mod4_3=orden_aleat[12,1]

    ##assigning the order of traits
    trait_order<-c(mod1_1,mod1_2,mod1_3,mod2_1,mod2_2,mod2_3,mod3_1,mod3_2
    ,mod3_3,mod4_1,mod4_2,mod4_3)


    write.table(trait_order,"trait_order.txt")


    }


    ################# THE WORLD - N, SPACE AND TIME ########################################################
    ########################################################################################################
    World_size=as.integer(switches$World_size)      ###NUMBER OF CELLS SET UNIDIMENSIONALLY

    cells<-1:World_size

    cells<-as.data.frame(cells)

    n_prey=switches$n_prey#500*3                                    ###NUMBER OF PREY
    n_pred=switches$n_pred#281*3  # as.integer(round(n_prey*(1/10),0))     ###NUMBER OF PREDATORS

    seed_prey=as.integer(round(runif(1)*100,0))   ###RANDOM ASSIGNMENT OF SEEDS
    seed_pred=as.integer(round(runif(1)*100,0))   ###RANDOM ASSIGNMENT OF SEEDS

    seeds<-data.frame(seed_prey,seed_pred)

    write.table(seeds,"seeds.txt")     ###SAVING THE SEEDS SO THE THING CAN BE REPEATED BELOW AND SOME OTHER TIME IF WE WANT TO


    ####fungi growth array
    fungi<-cells

    ##TO INCLUDE AUTOCORRELATION
    increase<-as.matrix(c(1:round(World_size/2,0)))
    decrease<-as.matrix(c(round(World_size/2,0):1))
    fungi$x<-as.matrix(rbind(increase,decrease))

    fungi$r<-interpol(fungi$x,min_r,max_r)


    fungi$ini<-interpol(fungi$x,min_fungi,max_fungi)
    fungi$K<-interpol(fungi$x,min_K,max_K)     ###########################################################################
    sum(fungi$K)

          ############################# TO REMOVE AUTOCORRELATION AND THE SAME r and ini ACROSS THE WORLD_SIZE CELLS #############################################
          if (autocor==0){
          names(fungi)

          set.seed(seed_prey)
          fungi$aleat<-runif(nrow(fungi))

          names(fungi)

          #[1] "cells" "r"     "ini"   "K" "aleat"

          r_sorted <- fungi[do.call(order,fungi[c(5)]),]  #finally how to sort in R

          r_sorted$orden<-as.numeric(World_size:1)

          r_sorted

          names(r_sorted)
          #[1] "cells" "r"     "ini"   "aleat" "orden"


          new_matrix<-as.data.frame(matrix(nrow=nrow(fungi),ncol=4))


          new_matrix[,1]=r_sorted$orden
          new_matrix[,2]=r_sorted$r
          new_matrix[,3]=r_sorted$ini
          new_matrix[,4]=r_sorted$K


          names(new_matrix)<-c("cells","r","ini","K")

          new_matrix

          fungi<-new_matrix[do.call(order,new_matrix[c(1)]),]

          }

  plot(fungi$cells,fungi$K)

  fungi$cells<-as.integer(fungi$cells)
  fungi$biomass_in<-matrix(nrow=nrow(fungi),ncol=steps)
  fungi$biomass_out<-matrix(nrow=nrow(fungi),ncol=steps)
  fungi$biomass<-matrix(nrow=nrow(fungi),ncol=steps)

  fungi$excess<-matrix(nrow=nrow(fungi),ncol=1,0)

  #############################################
  #### GENETIC FUNCTIONS ######################
  #############################################

    ###FOR 3-TRAIT MODULES
    #### this creates a chromosome type from which each individual samples its genetics
    #### for each of its 2 chromosomes
    crea_loci<-function(n_loci,n_alleles)
    {
    crom<-matrix(nrow=n_loci,ncol=1,0)

    crom<-as.data.frame(crom)

    crom$allel_ID<-matrix(nrow=nrow(crom),ncol=n_alleles)
    crom$allel_val<-matrix(nrow=nrow(crom),ncol=n_alleles)

    names(crom)[1:3]<-c("loc_num","allel_ID","allel_val")

    crom$loc_num<-as.integer(1:nrow(crom))

      for (i in 1:nrow(crom)){   ##locus i
        for (j in 1:n_alleles){  ##allele j
        crom$allel_ID[i,j]<-paste("ID",i,j,sep="_")
        min1=runif(1,min=0,max=0.5)
        max1=runif(1,min=0.5,max=1)
        crom$allel_val[i,j]<-runif(1,min=min1,max=max1)

        }
      }
    return(crom)
    }



     ##SAMPLING CHROMOSOMES FOR THE INDIVIDUALS FOR EACH 3-VARIABLE MODULE
    crea_module<-function(mod_num,mod_type,loci,n_loci,n_alleles,n_bichos,min_t1,max_t1,min_t2,max_t2,min_t3,max_t3,rho)
    {

    bichos<-as.data.frame(matrix(nrow=n_bichos,ncol=0))

    bichos$ID<-as.integer(1:nrow(bichos))

    bichos$trt1_cr1_ID<-matrix(nrow=nrow(bichos),ncol=n_loci)
    bichos$trt1_cr1_val<-matrix(nrow=nrow(bichos),ncol=n_loci)

    bichos$trt1_cr2_ID<-matrix(nrow=nrow(bichos),ncol=n_loci)
    bichos$trt1_cr2_val<-matrix(nrow=nrow(bichos),ncol=n_loci)

    bichos2<-as.data.frame(matrix(nrow=n_bichos,ncol=0))

    bichos2$trt2_cr1_ID<-matrix(nrow=nrow(bichos2),ncol=n_loci)
    bichos2$trt2_cr1_val<-matrix(nrow=nrow(bichos2),ncol=n_loci)

    bichos2$trt2_cr2_ID<-matrix(nrow=nrow(bichos2),ncol=n_loci)
    bichos2$trt2_cr2_val<-matrix(nrow=nrow(bichos2),ncol=n_loci)

    bichos3<-as.data.frame(matrix(nrow=n_bichos,ncol=0))

    bichos3$trt3_cr1_ID<-matrix(nrow=nrow(bichos3),ncol=n_loci)
    bichos3$trt3_cr1_val<-matrix(nrow=nrow(bichos3),ncol=n_loci)

    bichos3$trt3_cr2_ID<-matrix(nrow=nrow(bichos3),ncol=n_loci)
    bichos3$trt3_cr2_val<-matrix(nrow=nrow(bichos3),ncol=n_loci)


    ###assigning alleles at random for each individual, locus and each of the three traits in the module
    for (i in 1:nrow(bichos)){
      for (j in 1:n_loci){
    bichos$trt1_cr1_ID[i,j]<-loci$allel_ID[j,as.integer(runif(1,min=1,max=n_alleles+1))]
    bichos$trt1_cr2_ID[i,j]<-loci$allel_ID[j,as.integer(runif(1,min=1,max=n_alleles+1))]
    bichos2$trt2_cr1_ID[i,j]<-loci$allel_ID[j,as.integer(runif(1,min=1,max=n_alleles+1))]
    bichos2$trt2_cr2_ID[i,j]<-loci$allel_ID[j,as.integer(runif(1,min=1,max=n_alleles+1))]
    bichos3$trt3_cr1_ID[i,j]<-loci$allel_ID[j,as.integer(runif(1,min=1,max=n_alleles+1))]
    bichos3$trt3_cr2_ID[i,j]<-loci$allel_ID[j,as.integer(runif(1,min=1,max=n_alleles+1))]
    }
    }


    ###assigning values according to the alleles selected
    for (i in 1:nrow(bichos)){
      for (j in 1:n_loci){
    bichos$trt1_cr1_val[i,j]<-loci$allel_val[j,bichos$trt1_cr1_ID[i,j]==loci$allel_ID[j,]]
    bichos$trt1_cr2_val[i,j]<-loci$allel_val[j,bichos$trt1_cr2_ID[i,j]==loci$allel_ID[j,]]
    bichos2$trt2_cr1_val[i,j]<-loci$allel_val[j,bichos2$trt2_cr1_ID[i,j]==loci$allel_ID[j,]]
    bichos2$trt2_cr2_val[i,j]<-loci$allel_val[j,bichos2$trt2_cr2_ID[i,j]==loci$allel_ID[j,]]
    bichos3$trt3_cr1_val[i,j]<-loci$allel_val[j,bichos3$trt3_cr1_ID[i,j]==loci$allel_ID[j,]]
    bichos3$trt3_cr2_val[i,j]<-loci$allel_val[j,bichos3$trt3_cr2_ID[i,j]==loci$allel_ID[j,]]
    }
    }



    bichos$phenotype1<-rowSums(bichos$trt1_cr1_val)+rowSums(bichos$trt1_cr2_val)

    rho=1-rho ###to induce the desired effect and parallel this to genetic correlation

    if (mod_type=="neg"){
    bichos2$phenotype2<-rowSums(bichos2$trt2_cr1_val[,1:round(rho*n_loci,0)])+
    rowSums(bichos2$trt2_cr2_val[,1:round(rho*n_loci,0)])+
    rowSums((1-bichos$trt1_cr1_val[,(round(rho*n_loci,0)+1):n_loci]))+
    rowSums((1-bichos$trt1_cr2_val[,(round(rho*n_loci,0)+1):n_loci]))
    }
    if (mod_type=="pos"){
    bichos2$phenotype2<-rowSums(bichos2$trt2_cr1_val[,1:round(rho*n_loci,0)])+
    rowSums(bichos2$trt2_cr2_val[,1:round(rho*n_loci,0)])+
    rowSums((bichos$trt1_cr1_val[,(round(rho*n_loci,0)+1):n_loci]))+
    rowSums((bichos$trt1_cr2_val[,(round(rho*n_loci,0)+1):n_loci]))
    }



    if (mod_type=="neg"){
    bichos3$phenotype3<-rowSums(bichos3$trt3_cr1_val[,1:round(rho*n_loci,0)])+
    rowSums(bichos3$trt3_cr2_val[,1:round(rho*n_loci,0)])+
    rowSums((1-bichos$trt1_cr1_val[,(round(rho*n_loci,0)+1):n_loci]))+
    rowSums((1-bichos$trt1_cr2_val[,(round(rho*n_loci,0)+1):n_loci]))
    }
    if (mod_type=="pos"){
    bichos3$phenotype3<-rowSums(bichos3$trt3_cr1_val[,1:round(rho*n_loci,0)]) +
    rowSums(bichos3$trt3_cr2_val[,1:round(rho*n_loci,0)])+
    rowSums((bichos$trt1_cr1_val[,(round(rho*n_loci,0)+1):n_loci]))+
    rowSums((bichos$trt1_cr2_val[,(round(rho*n_loci,0)+1):n_loci]))
    }


    three_traits<-data.frame(bichos,bichos2,bichos3)
    return(three_traits)
    }


    ###FOR SINGLE TRAIT
    #### this creates a chromosome type from which each individual samples its genetics
    #### for each of its 2 chromosomes - SINGLE-TRAIT VERSION
    crea_trait<-function(loci,n_loci,n_alleles,n_bichos,min_t1,max_t1)
    {


    bichos<-as.data.frame(matrix(nrow=n_bichos,ncol=0))

    bichos$trt1_cr1_ID<-matrix(nrow=nrow(bichos),ncol=n_loci)
    bichos$trt1_cr1_val<-matrix(nrow=nrow(bichos),ncol=n_loci)

    bichos$trt1_cr2_ID<-matrix(nrow=nrow(bichos),ncol=n_loci)
    bichos$trt1_cr2_val<-matrix(nrow=nrow(bichos),ncol=n_loci)

    for (i in 1:nrow(bichos)){
    for (j in 1:n_loci){
    bichos$trt1_cr1_ID[i,j]<-loci$allel_ID[j,as.integer(runif(1,min=1,max=n_alleles+1))]
    bichos$trt1_cr2_ID[i,j]<-loci$allel_ID[j,as.integer(runif(1,min=1,max=n_alleles+1))]
    }
    }


    for (i in 1:nrow(bichos)){
    for (j in 1:n_loci){
    bichos$trt1_cr1_val[i,j]<-loci$allel_val[j,bichos$trt1_cr1_ID[i,j]==loci$allel_ID[j,]]
    bichos$trt1_cr2_val[i,j]<-loci$allel_val[j,bichos$trt1_cr2_ID[i,j]==loci$allel_ID[j,]]
    }
    }


    bichos$phenotype1<-rowSums(bichos$trt1_cr1_val)+rowSums(bichos$trt1_cr2_val)


    trait<-bichos
    return(trait)
    }


    ###FOR SINGLE TRAIT
    #### this creates a chromosome type from which each individual samples its genetics
    #### for each of its 2 chromosomes - SINGLE-TRAIT VERSION
    crea_trait<-function(loci,n_loci,n_alleles,n_bichos,min_t1,max_t1)
    {


    bichos<-as.data.frame(matrix(nrow=n_bichos,ncol=0))

    bichos$trt1_cr1_ID<-matrix(nrow=nrow(bichos),ncol=n_loci)
    bichos$trt1_cr1_val<-matrix(nrow=nrow(bichos),ncol=n_loci)

    bichos$trt1_cr2_ID<-matrix(nrow=nrow(bichos),ncol=n_loci)
    bichos$trt1_cr2_val<-matrix(nrow=nrow(bichos),ncol=n_loci)

    for (i in 1:nrow(bichos)){
    for (j in 1:n_loci){
    bichos$trt1_cr1_ID[i,j]<-loci$allel_ID[j,as.integer(runif(1,min=1,max=n_alleles+1))]
    bichos$trt1_cr2_ID[i,j]<-loci$allel_ID[j,as.integer(runif(1,min=1,max=n_alleles+1))]
    }
    }


    for (i in 1:nrow(bichos)){
    for (j in 1:n_loci){
    bichos$trt1_cr1_val[i,j]<-loci$allel_val[j,bichos$trt1_cr1_ID[i,j]==loci$allel_ID[j,]]
    bichos$trt1_cr2_val[i,j]<-loci$allel_val[j,bichos$trt1_cr2_ID[i,j]==loci$allel_ID[j,]]
    }
    }


    bichos$phenotype1<-rowSums(bichos$trt1_cr1_val)+rowSums(bichos$trt1_cr2_val)


    trait<-bichos
    return(trait)
    }



  #######################################
  #### PREY TRAITS ######################
  #######################################

  loci<-crea_loci(n_loci,n_alleles)

  ###PREY MOD1 - calls functions to originate the phenotypes for module 1
  mod1<-crea_module(mod_num="mod_1",mod_type=prey_mod_int_1,loci,n_loci,n_alleles,
  n_prey,trait_vals[mod1_1,2],trait_vals[mod1_1,3],trait_vals[mod1_2,2],trait_vals[mod1_2,3],
  trait_vals[mod1_3,2],trait_vals[mod1_3,3],rho_prey)

  names(mod1)[6]<-trait_vals[mod1_1,1]
  names(mod1)[11]<-trait_vals[mod1_2,1]
  names(mod1)[16]<-trait_vals[mod1_3,1]

  trait_vals[trait_vals$trait==names(mod1)[6],6]<-min(mod1[,6])
  trait_vals[trait_vals$trait==names(mod1)[6],7]<-max(mod1[,6])
  trait_vals[trait_vals$trait==names(mod1)[11],6]<-min(mod1[,11])
  trait_vals[trait_vals$trait==names(mod1)[11],7]<-max(mod1[,11])
  trait_vals[trait_vals$trait==names(mod1)[16],6]<-min(mod1[,16])
  trait_vals[trait_vals$trait==names(mod1)[16],7]<-max(mod1[,16])

  mod1[,6]<-interpol2(mod1[,6],trait_vals[trait_vals$trait==names(mod1)[6],6],
  trait_vals[trait_vals$trait==names(mod1)[6],7],trait_vals[mod1_1,2],trait_vals[mod1_1,3])

  mod1[,11]<-interpol2(mod1[,11],trait_vals[trait_vals$trait==names(mod1)[11],6],
  trait_vals[trait_vals$trait==names(mod1)[11],7],trait_vals[mod1_2,2],trait_vals[mod1_2,3])

  mod1[,16]<-interpol2(mod1[,16],trait_vals[trait_vals$trait==names(mod1)[16],6],
  trait_vals[trait_vals$trait==names(mod1)[16],7],trait_vals[mod1_3,2],trait_vals[mod1_3,3])

  library(psych)
  corr.test(mod1[,c(6,11,16)])

  


  ###PREY MOD2
  mod2<-crea_module(mod_num="mod_2",mod_type=prey_mod_int_2,loci,n_loci,n_alleles,
  n_prey,trait_vals[mod2_1,2],trait_vals[mod2_1,3],trait_vals[mod2_2,2],trait_vals[mod2_2,3],
  trait_vals[mod2_3,2],trait_vals[mod2_3,3],rho_prey)

  names(mod2)[6]<-trait_vals[mod2_1,1]
  names(mod2)[11]<-trait_vals[mod2_2,1]
  names(mod2)[16]<-trait_vals[mod2_3,1]

  trait_vals[trait_vals$trait==names(mod2)[6],6]<-min(mod2[,6])
  trait_vals[trait_vals$trait==names(mod2)[6],7]<-max(mod2[,6])
  trait_vals[trait_vals$trait==names(mod2)[11],6]<-min(mod2[,11])
  trait_vals[trait_vals$trait==names(mod2)[11],7]<-max(mod2[,11])
  trait_vals[trait_vals$trait==names(mod2)[16],6]<-min(mod2[,16])
  trait_vals[trait_vals$trait==names(mod2)[16],7]<-max(mod2[,16])

  mod2[,6]<-interpol2(mod2[,6],trait_vals[trait_vals$trait==names(mod2)[6],6],
  trait_vals[trait_vals$trait==names(mod2)[6],7],trait_vals[mod2_1,2],trait_vals[mod2_1,3])

  mod2[,11]<-interpol2(mod2[,11],trait_vals[trait_vals$trait==names(mod2)[11],6],
  trait_vals[trait_vals$trait==names(mod2)[11],7],trait_vals[mod2_2,2],trait_vals[mod2_2,3])

  mod2[,16]<-interpol2(mod2[,16],trait_vals[trait_vals$trait==names(mod2)[16],6],
  trait_vals[trait_vals$trait==names(mod2)[16],7],trait_vals[mod2_3,2],trait_vals[mod2_3,3])


  
  ###PREY MOD3
  mod3<-crea_module(mod_num="mod_3",mod_type=prey_mod_int_3,loci,n_loci,n_alleles,
  n_prey,trait_vals[mod3_1,2],trait_vals[mod3_1,3],trait_vals[mod3_2,2],trait_vals[mod3_2,3],
  trait_vals[mod3_3,2],trait_vals[mod3_3,3],rho_prey)

  names(mod3)[6]<-trait_vals[mod3_1,1]
  names(mod3)[11]<-trait_vals[mod3_2,1]
  names(mod3)[16]<-trait_vals[mod3_3,1]

  trait_vals[trait_vals$trait==names(mod3)[6],6]<-min(mod3[,6])
  trait_vals[trait_vals$trait==names(mod3)[6],7]<-max(mod3[,6])
  trait_vals[trait_vals$trait==names(mod3)[11],6]<-min(mod3[,11])
  trait_vals[trait_vals$trait==names(mod3)[11],7]<-max(mod3[,11])
  trait_vals[trait_vals$trait==names(mod3)[16],6]<-min(mod3[,16])
  trait_vals[trait_vals$trait==names(mod3)[16],7]<-max(mod3[,16])

  mod3[,6]<-interpol2(mod3[,6],trait_vals[trait_vals$trait==names(mod3)[6],6],
  trait_vals[trait_vals$trait==names(mod3)[6],7],trait_vals[mod3_1,2],trait_vals[mod3_1,3])

  mod3[,11]<-interpol2(mod3[,11],trait_vals[trait_vals$trait==names(mod3)[11],6],
  trait_vals[trait_vals$trait==names(mod3)[11],7],trait_vals[mod3_2,2],trait_vals[mod3_2,3])

  mod3[,16]<-interpol2(mod3[,16],trait_vals[trait_vals$trait==names(mod3)[16],6],
  trait_vals[trait_vals$trait==names(mod3)[16],7],trait_vals[mod3_3,2],trait_vals[mod3_3,3])


  ###PREY MOD4
  mod4<-crea_module(mod_num="mod_4",mod_type=prey_mod_int_4,loci,n_loci,n_alleles,
  n_prey,trait_vals[mod4_1,2],trait_vals[mod4_1,3],trait_vals[mod4_2,2],trait_vals[mod4_2,3],
  trait_vals[mod4_3,2],trait_vals[mod4_3,3],rho_prey)

  names(mod4)[6]<-trait_vals[mod4_1,1]
  names(mod4)[11]<-trait_vals[mod4_2,1]
  names(mod4)[16]<-trait_vals[mod4_3,1]

  trait_vals[trait_vals$trait==names(mod4)[6],6]<-min(mod4[,6])
  trait_vals[trait_vals$trait==names(mod4)[6],7]<-max(mod4[,6])
  trait_vals[trait_vals$trait==names(mod4)[11],6]<-min(mod4[,11])
  trait_vals[trait_vals$trait==names(mod4)[11],7]<-max(mod4[,11])
  trait_vals[trait_vals$trait==names(mod4)[16],6]<-min(mod4[,16])
  trait_vals[trait_vals$trait==names(mod4)[16],7]<-max(mod4[,16])

  mod4[,6]<-interpol2(mod4[,6],trait_vals[trait_vals$trait==names(mod4)[6],6],
  trait_vals[trait_vals$trait==names(mod4)[6],7],trait_vals[mod4_1,2],trait_vals[mod4_1,3])

  mod4[,11]<-interpol2(mod4[,11],trait_vals[trait_vals$trait==names(mod4)[11],6],
  trait_vals[trait_vals$trait==names(mod4)[11],7],trait_vals[mod4_2,2],trait_vals[mod4_2,3])

  mod4[,16]<-interpol2(mod4[,16],trait_vals[trait_vals$trait==names(mod4)[16],6],
  trait_vals[trait_vals$trait==names(mod4)[16],7],trait_vals[mod4_3,2],trait_vals[mod4_3,3])


  ###PREY actE_met
  actE_met<-crea_trait(loci,n_loci,n_alleles,n_prey,
  trait_vals[trait_vals$trait=="actE_met",2],trait_vals[trait_vals$trait=="actE_met",3])

  trait_vals[trait_vals$trait=="actE_met",6]<-min(actE_met$phenotype1)
  trait_vals[trait_vals$trait=="actE_met",7]<-max(actE_met$phenotype1)

  actE_met$phenotype1<-interpol2(actE_met$phenotype1,trait_vals[trait_vals$trait=="actE_met",6]
  ,trait_vals[trait_vals$trait=="actE_met",7],trait_vals[trait_vals$trait=="actE_met",2],
  trait_vals[trait_vals$trait=="actE_met",3])


  ###below we decouple genes from phenotypes to speed up the simulation
  ###genes are not really necessary until reproduction, as there is no developmental plasticity yet
  prey_w_genes<-data.frame(mod1,mod2,mod3,mod4,actE_met)

  names(prey_w_genes)[length(prey_w_genes)]<-c("actE_met")

  prey<-prey_w_genes[,c("ID","energy_tank","voracity","speed","body_size","met_rate","growth","search_area"
    ,"assim","pheno","vorQ10","spdQ10","srchQ10","actE_met")]

  prey$pheno<-as.integer(round(prey$pheno,0))
  
  ### OTHER STATE VARIABLES ####
    pasos<-c(nrow(prey))  ##the number of cells actually walked on in one step - depends upon "search_area_tuned" and on what happens (finding food, a predator, etc.)
    pasos[1:nrow(prey)]<-0
    prey$pasos<-as.integer(pasos)

    prey$eaten<-as.data.frame(matrix(nrow=nrow(prey),ncol=1))     ##the amount of food eaten each day (step)
    prey$eaten<-0

    set.seed(1)
    prey$coord_prey<-round(runif(nrow(prey),min=1,max=World_size),0)      ##the initial positions - seeds are always the same for simplicity

    prey$alive<-as.integer(0)    ##0 means the animal has not been born, 1 - is active, 2 - dead from starvation, 3 - predated, 4 - became adult, reproduced and died

    prey$encounters_prey<-as.integer(0)  ###to measure the actual number of encounters with predators each day (or prey if in predators)

    prey$encounters_pred<-as.integer(0)  ###to measure the actual number of encounters with predators each day (or prey if in predators)

    prey$global_prey_encs<-as.integer(0)
    prey$global_pred_encs<-as.integer(0)


    prey$instar<-as.integer(1)    ###to keeptrack the number of molts the animal has undergone

    prey$random<-runif(nrow(prey))

    prey<-prey[do.call(order,prey[c("random")]),]

    prey$ID<-as.integer(prey$ID)


    prey$pred_prey<-as.character("prey")  ###whether is a "prey" or a predator "pred"

    prey$date_death<-as.integer(0)

    prey$size_ini<-prey$body_size      ###to keeptrack the initial size
    prey$tank_ini<-prey$energy_tank    ###as energy_tank here is merely the coefficient
    prey$speed_ini<-prey$speed
    prey$assim_ini<-prey$assim
    prey$energy_tank<-prey$body_size*prey$tank_ini   ###tank_ini is the coefficient (proportion of tank_ini) and energy_tank is a proportion of body size here.
    
    coeff_speed<-matrix(nrow=nrow(prey),ncol=1)
    coeff_speed<-interpol2(prey$speed_ini,0.05,0.35,1,7)
    
    
    prey$speed<-coeff_speed*(prey$body_size+prey$energy_tank)^prey$speed_ini

   prey$critical<-prey$energy_tank/prey$body_size    ##this ratio measures the amount of energy stored relative to the body size, necessary to estimate starvation and or moulting


  prey$voracity_tuned<-prey$voracity#0.1*(prey$size_ini+prey$tank_ini)^prey$voracity
  prey$search_area_tuned<-prey$search_area#(prey$size_ini+prey$tank_ini)^prey$search_area

  prey$g_numb_prt1<-0 ##generation number of one of the parents
  prey$g_numb_prt2<-0 ##generation number of the other parent

  prey$ID_prt1<-0 ##generation number of one of the parents
  prey$ID_prt2<-0

  prey$rep_count=0  ##number of reproductive events (number of clutches)

  prey$fecundity=0  ##total number of offspring

  prey$age_rep=0  ##age at first reproduction

  if (predators==1){
  #### PREDATOR TRAITS ######################
  ###########################################
  ###########################################
  ###pred MOD1
  ###pred MOD1 - calls functions to originate the phenotypes for module 1
  mod1<-crea_module(mod_num="mod_1",mod_type=pred_mod_int_1,loci,n_loci,n_alleles,
  n_pred,trait_vals[mod1_1,4],trait_vals[mod1_1,5],trait_vals[mod1_2,4],trait_vals[mod1_2,5],
  trait_vals[mod1_3,4],trait_vals[mod1_3,5],rho_pred)

  names(mod1)[6]<-trait_vals[mod1_1,1]
  names(mod1)[11]<-trait_vals[mod1_2,1]
  names(mod1)[16]<-trait_vals[mod1_3,1]

  trait_vals[trait_vals$trait==names(mod1)[6],8]<-min(mod1[,6])
  trait_vals[trait_vals$trait==names(mod1)[6],9]<-max(mod1[,6])
  trait_vals[trait_vals$trait==names(mod1)[11],8]<-min(mod1[,11])
  trait_vals[trait_vals$trait==names(mod1)[11],9]<-max(mod1[,11])
  trait_vals[trait_vals$trait==names(mod1)[16],8]<-min(mod1[,16])
  trait_vals[trait_vals$trait==names(mod1)[16],9]<-max(mod1[,16])



  mod1[,6]<-interpol2(mod1[,6],trait_vals[trait_vals$trait==names(mod1)[6],8],
  trait_vals[trait_vals$trait==names(mod1)[6],9],trait_vals[mod1_1,4],trait_vals[mod1_1,5])

  mod1[,11]<-interpol2(mod1[,11],trait_vals[trait_vals$trait==names(mod1)[11],8],
  trait_vals[trait_vals$trait==names(mod1)[11],9],trait_vals[mod1_2,4],trait_vals[mod1_2,5])

  mod1[,16]<-interpol2(mod1[,16],trait_vals[trait_vals$trait==names(mod1)[16],8],
  trait_vals[trait_vals$trait==names(mod1)[16],9],trait_vals[mod1_3,4],trait_vals[mod1_3,5])




  ###pred MOD2
  mod2<-crea_module(mod_num="mod_2",mod_type=pred_mod_int_2,loci,n_loci,n_alleles,
  n_pred,trait_vals[mod2_1,4],trait_vals[mod2_1,5],trait_vals[mod2_2,4],trait_vals[mod2_2,5],
  trait_vals[mod2_3,4],trait_vals[mod2_3,5],rho_pred)

  names(mod2)[6]<-trait_vals[mod2_1,1]
  names(mod2)[11]<-trait_vals[mod2_2,1]
  names(mod2)[16]<-trait_vals[mod2_3,1]

  trait_vals[trait_vals$trait==names(mod2)[6],8]<-min(mod2[,6])
  trait_vals[trait_vals$trait==names(mod2)[6],9]<-max(mod2[,6])
  trait_vals[trait_vals$trait==names(mod2)[11],8]<-min(mod2[,11])
  trait_vals[trait_vals$trait==names(mod2)[11],9]<-max(mod2[,11])
  trait_vals[trait_vals$trait==names(mod2)[16],8]<-min(mod2[,16])
  trait_vals[trait_vals$trait==names(mod2)[16],9]<-max(mod2[,16])

  mod2[,6]<-interpol2(mod2[,6],trait_vals[trait_vals$trait==names(mod2)[6],8],
  trait_vals[trait_vals$trait==names(mod2)[6],9],trait_vals[mod2_1,4],trait_vals[mod2_1,5])

  mod2[,11]<-interpol2(mod2[,11],trait_vals[trait_vals$trait==names(mod2)[11],8],
  trait_vals[trait_vals$trait==names(mod2)[11],9],trait_vals[mod2_2,4],trait_vals[mod2_2,5])

  mod2[,16]<-interpol2(mod2[,16],trait_vals[trait_vals$trait==names(mod2)[16],8],
  trait_vals[trait_vals$trait==names(mod2)[16],9],trait_vals[mod2_3,4],trait_vals[mod2_3,5])


  library(psych)
  corr.test(mod2[,c(6,11,16)])


  ###pred MOD3
  mod3<-crea_module(mod_num="mod_3",mod_type=pred_mod_int_3,loci,n_loci,n_alleles,
  n_pred,trait_vals[mod3_1,4],trait_vals[mod3_1,5],trait_vals[mod3_2,4],trait_vals[mod3_2,5],
  trait_vals[mod3_3,4],trait_vals[mod3_3,5],rho_pred)

  names(mod3)[6]<-trait_vals[mod3_1,1]
  names(mod3)[11]<-trait_vals[mod3_2,1]
  names(mod3)[16]<-trait_vals[mod3_3,1]

  trait_vals[trait_vals$trait==names(mod3)[6],8]<-min(mod3[,6])
  trait_vals[trait_vals$trait==names(mod3)[6],9]<-max(mod3[,6])
  trait_vals[trait_vals$trait==names(mod3)[11],8]<-min(mod3[,11])
  trait_vals[trait_vals$trait==names(mod3)[11],9]<-max(mod3[,11])
  trait_vals[trait_vals$trait==names(mod3)[16],8]<-min(mod3[,16])
  trait_vals[trait_vals$trait==names(mod3)[16],9]<-max(mod3[,16])

  mod3[,6]<-interpol2(mod3[,6],trait_vals[trait_vals$trait==names(mod3)[6],8],
  trait_vals[trait_vals$trait==names(mod3)[6],9],trait_vals[mod3_1,4],trait_vals[mod3_1,5])

  mod3[,11]<-interpol2(mod3[,11],trait_vals[trait_vals$trait==names(mod3)[11],8],
  trait_vals[trait_vals$trait==names(mod3)[11],9],trait_vals[mod3_2,4],trait_vals[mod3_2,5])

  mod3[,16]<-interpol2(mod3[,16],trait_vals[trait_vals$trait==names(mod3)[16],8],
  trait_vals[trait_vals$trait==names(mod3)[16],9],trait_vals[mod3_3,4],trait_vals[mod3_3,5])


  ###pred MOD4
  mod4<-crea_module(mod_num="mod_4",mod_type=pred_mod_int_4,loci,n_loci,n_alleles,
  n_pred,trait_vals[mod4_1,4],trait_vals[mod4_1,5],trait_vals[mod4_2,4],trait_vals[mod4_2,5],
  trait_vals[mod4_3,4],trait_vals[mod4_3,5],rho_pred)

  names(mod4)[6]<-trait_vals[mod4_1,1]
  names(mod4)[11]<-trait_vals[mod4_2,1]
  names(mod4)[16]<-trait_vals[mod4_3,1]

  trait_vals[trait_vals$trait==names(mod4)[6],8]<-min(mod4[,6])
  trait_vals[trait_vals$trait==names(mod4)[6],9]<-max(mod4[,6])
  trait_vals[trait_vals$trait==names(mod4)[11],8]<-min(mod4[,11])
  trait_vals[trait_vals$trait==names(mod4)[11],9]<-max(mod4[,11])
  trait_vals[trait_vals$trait==names(mod4)[16],8]<-min(mod4[,16])
  trait_vals[trait_vals$trait==names(mod4)[16],9]<-max(mod4[,16])

  mod4[,6]<-interpol2(mod4[,6],trait_vals[trait_vals$trait==names(mod4)[6],8],
  trait_vals[trait_vals$trait==names(mod4)[6],9],trait_vals[mod4_1,4],trait_vals[mod4_1,5])

  mod4[,11]<-interpol2(mod4[,11],trait_vals[trait_vals$trait==names(mod4)[11],8],
  trait_vals[trait_vals$trait==names(mod4)[11],9],trait_vals[mod4_2,4],trait_vals[mod4_2,5])

  mod4[,16]<-interpol2(mod4[,16],trait_vals[trait_vals$trait==names(mod4)[16],8],
  trait_vals[trait_vals$trait==names(mod4)[16],9],trait_vals[mod4_3,4],trait_vals[mod4_3,5])


  ###pred actE_met
  actE_met<-crea_trait(loci,n_loci,n_alleles,n_pred,
  trait_vals[trait_vals$trait=="actE_met",4],trait_vals[trait_vals$trait=="actE_met",5])

  trait_vals[trait_vals$trait=="actE_met",8]<-min(actE_met$phenotype1)
  trait_vals[trait_vals$trait=="actE_met",9]<-max(actE_met$phenotype1)

  actE_met$phenotype1<-interpol2(actE_met$phenotype1,trait_vals[trait_vals$trait=="actE_met",8]
  ,trait_vals[trait_vals$trait=="actE_met",9],trait_vals[trait_vals$trait=="actE_met",4],
  trait_vals[trait_vals$trait=="actE_met",5])



#  library(psych)
#  corr.test(mod3[,c("voracity","assim","body_size")])

  ###below we decouple genes from phenotypes to speed up the simulation
  ###genes are not really necessary until reproduction, as there is no plasticity yet
  pred_w_genes<-data.frame(mod1,mod2,mod3,mod4,actE_met)

  names(pred_w_genes)[length(pred_w_genes)]<-c("actE_met")

  pred<-pred_w_genes[,c("ID","energy_tank","voracity","speed","body_size","met_rate","growth","search_area"
    ,"assim","pheno","vorQ10","spdQ10","srchQ10","actE_met")]


  pred$pheno<-as.integer(round(pred$pheno,0))
  
  #pred

  ### OTHER STATE VARIABLES ####
    pasos<-c(nrow(pred))  ##the number of cells actually walked on in one step
    pasos[1:nrow(pred)]<-0
    pred$pasos<-as.integer(pasos)

    pred$eaten<-as.data.frame(matrix(nrow=nrow(pred),ncol=1))
    pred$eaten<-0

    set.seed(10)
    pred$coord_pred<-round(runif(nrow(pred),min=1,max=World_size),0)

    pred$alive<-as.integer(0) ###adds a new state which is 5, death from background mortality

    pred$encounters_prey<-as.integer(0)

    pred$encounters_pred<-as.integer(0)

    pred$global_prey_encs<-as.integer(0)
    pred$global_pred_encs<-as.integer(0)

    pred$instar<-as.integer(1)

    pred$eating<-as.integer(0)

    pred$food_mass<-0.0 ##food ingested by predator at each step - this is then passed upon a feeding function for assessing assimmilation

    pred$random<-runif(nrow(pred))

    pred<-pred[do.call(order,pred[c("random")]),]

    pred$ID<-as.integer(pred$ID)

    pred$pred_prey<-as.character("pred")

    pred$date_death<-as.integer(0)

    pred$size_ini<-pred$body_size
    pred$tank_ini<-pred$energy_tank    ###as energy_tank here is merely the coefficient
    pred$speed_ini<-pred$speed
    pred$assim_ini<-pred$assim
    pred$energy_tank<-pred$body_size*pred$tank_ini   ###tank_ini is the coefficient (proportion of tank_ini) and energy_tank is a proportion of body size here.
    
    coeff_speed<-matrix(nrow=nrow(pred),ncol=1)
    coeff_speed<-interpol2(pred$speed_ini,0.05,0.35,1,7)
    
    pred$speed<-coeff_speed*(pred$body_size+pred$energy_tank)^pred$speed_ini

    pred$critical<-pred$energy_tank/pred$body_size

    pred$days_digest<-as.integer(0) ##this counts for how long this predator will be digesting the current item according to voracity.

    pred$voracity_tuned<-pred$voracity#0.1*(pred$size_ini+pred$tank_ini)^pred$voracity
    pred$search_area_tuned<-pred$search_area#(pred$size_ini+pred$tank_ini)^pred$search_area

    pred$g_numb_prt1<-0 ##generation number of one of the parents
    pred$g_numb_prt2<-0 ##generation number of the other parent

    pred$ID_prt1<-0 ##generation number of one of the parents
    pred$ID_prt2<-0

    pred$rep_count=0 ##number of reproductive events (number of clutches)

    pred$fecundity=0 ##total number of offspring

    pred$age_rep=0  ##age at first reproduction

    }##end predator_trait_function


  ### here we save the date for using the same initial individuals across the current simulation
  prey2<-prey
  prey_w_genes2<-prey_w_genes
  pred2<-pred
  pred_w_genes2<-pred_w_genes

####the position of the following is important so it does not update the second simulation
prey$pheno<-round(prey$pheno*interpol2(T,min_T,max_T,1,Q10pheno),0) ##to include Q10 in dev time
pred$pheno<-round(pred$pheno*interpol2(T,min_T,max_T,1,Q10pheno),0) ##to include Q10 in dev time


####initialization ends here

    ##############################################################################################################################################
    ##############################################################################################################################################
    ##############################################################################################################################################


  ### fungi growth algorithm - if carrying capacity K is approached in one cell, fungi expand to the next cell

  fungi_func<-function(cells,fungi,i)
     {

     for (j in 1:nrow(cells)){


     if (i==1){
     fungi$r[j]<-exp(25.98-(0.68*(1/(0.0000862*(T+273.15)))))/((fungi$ini[j]*1000)^(1/4))
     fungi$biomass[j,i]=fungi$ini[j]+(fungi$r[j]*fungi$ini[j]*(1-fungi$ini[j]/fungi$K[j]))
     }

     if (i>1)
     if(fungi$biomass[j,i-1]>0){
     fungi$r[j]<-exp(25.98-(0.68*(1/(0.0000862*(T+273.15)))))/((fungi$biomass[j,i-1]*1000)^(1/4))
     fungi$biomass[j,i]=fungi$biomass[j,i-1]+(fungi$r[j]*fungi$biomass[j,i-1]*(1-fungi$biomass[j,i-1]/fungi$K[j]))
     }

     if (i>1)
     if(fungi$biomass[j,i-1]<=0)
     fungi$biomass[j,i]=0

   #  if (j>16&j<28)
#     print(cbind(fungi$biomass[j,i],fungi$K[j]))


     if (i>1){    ##is there an excess because K is approach?
     if(fungi$biomass[j,i]>=0.99*fungi$K[j])  ##0.99 as to make the algorithm efficient even if K is not reached
     {
     fungi$excess[j]=fungi$ini[j] ##the excess equals the initial quantity in this cell, thus potentially rescuing neighbor patches
     fungi$biomass[j,i]=fungi$K[j]
     }
     }
     }

     if (i>1){               ## the excess of fungi above K is leeked to the closest neigbourgh with least fungi
     for (j in 1:nrow(cells)){
     if (fungi$excess[j]>0){

     if (fungi$cells[j]>1&fungi$cells[j]<World_size){
     if (fungi$biomass[j-1,i]<fungi$K[j-1]&fungi$biomass[j+1,i]<=fungi$K[j+1]){
     if (fungi$biomass[j-1,i]<=fungi$biomass[j+1,i]){
     fungi$biomass[j-1,i]=fungi$excess[j]+fungi$biomass[j-1,i]
     }else{
     fungi$biomass[j+1,i]=fungi$excess[j]+fungi$biomass[j+1,i]
     }
     }
     if (fungi$biomass[j-1,i]<fungi$K[j-1]&fungi$biomass[j+1,i]>fungi$K[j+1]){
     fungi$biomass[j-1,i]=fungi$excess[j]+fungi$biomass[j-1,i]
     }else{
     if (fungi$biomass[j-1,i]>fungi$K[j-1]&fungi$biomass[j+1,i]<fungi$K[j+1]){
     fungi$biomass[j+1,i]=fungi$excess[j]+fungi$biomass[j+1,i]
     }
     }
     }


     if (fungi$cells[j]==1){
     if (fungi$biomass[World_size,i]<fungi$K[World_size]&fungi$biomass[2,i]<=fungi$K[2]){
     if (fungi$biomass[World_size,i]<=fungi$biomass[2,i]){
     fungi$biomass[World_size,i]=fungi$excess[j]+fungi$biomass[World_size,i]
     }else{
     fungi$biomass[2,i]=fungi$excess[j]+fungi$biomass[2,i]
     }
     }
     if (fungi$biomass[World_size,i]<fungi$K[World_size]&fungi$biomass[2,i]>fungi$K[2]){
     fungi$biomass[World_size,i]=fungi$excess[j]+fungi$biomass[World_size,i]
     }else{
     if (fungi$biomass[World_size,i]>fungi$K[World_size]&fungi$biomass[2,i]<fungi$K[2]){
     fungi$biomass[2,i]=fungi$excess[j]+fungi$biomass[2,i]
     }
     }
     }

     if (fungi$cells[j]==World_size){
     if (fungi$biomass[World_size-1,i]<fungi$K[World_size-1]&fungi$biomass[1,i]<=fungi$K[1]){
     if (fungi$biomass[World_size-1,i]<=fungi$biomass[1,i]){
     fungi$biomass[World_size-1,i]=fungi$excess[j]+fungi$biomass[World_size-1,i]
     }else{
     fungi$biomass[1,i]=fungi$excess[j]+fungi$biomass[1,i]
     }
     }
     if (fungi$biomass[World_size-1,i]<fungi$K[World_size-1]&fungi$biomass[1,i]>fungi$K[1]){
     fungi$biomass[World_size-1,i]=fungi$excess[j]+fungi$biomass[World_size-1,i]
     }else{
     if (fungi$biomass[World_size-1,i]>fungi$K[World_size-1]&fungi$biomass[1,i]<fungi$K[1]){
     fungi$biomass[1,i]=fungi$excess[j]+fungi$biomass[1,i]
     }
     }
     }

     }
     fungi$excess[j]=0
     }
     }

     if (i>1){                 ###if after leeking from nearby cells biomass is above K, it is reset to K
     for (j in 1:nrow(cells)){
     if (fungi$biomass[j,i]>fungi$K[j])
     fungi$biomass[j,i]=fungi$K[j]
     }
     }

     fungi$biomass_in[,i]<-fungi$biomass[,i]
     fungi$biomass_out[,i]<-0


     return(fungi)
  }


  if (predators==0 | adaptive==0){    
  ###### prey moving algorithm when there are NO predators around - at each movement (there can be more than one in one day-step) they move to immediate cells with more fungi
  prey_mov<-function(prey,pred,fungi,i,World_size,j)
  {
  if (prey$coord_prey[j]==World_size){


       current_cell_b=interpol2(fungi$biomass[World_size,i],0,K,0.01,1)
       left_cell_b=interpol2(fungi$biomass[World_size-1,i],0,K,0.01,1)
       right_cell_b=interpol2(fungi$biomass[1,i],0,K,0.01,1)

       current_cell_r=1/current_cell_b
       left_cell_r=1/left_cell_b
       right_cell_r=1/right_cell_b



    if (current_cell_b == 0.01&current_cell_b == left_cell_b&right_cell_b == left_cell_b)
    {
     salto <-round(runif(1,min=2,max=prey$search_area_tuned[j]+2),0)  ##"salto" means "jump" in Spanish, when the cells to the right and to the left have no fungi, they jump longer distances
     ##+2 to avoid NAs from max<min

         valor<-runif(1)
         if (valor>0.4999){
         prey$coord_prey[j]<-salto
         prey$pasos[j]=salto
         }else{
         prey$coord_prey[j]<-World_size-salto
         prey$pasos[j]=salto
         }

    }else{
    if (right_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
         prey$coord_prey[j]=1
         prey$pasos[j]=prey$pasos[j]+1
    }else{
     if (left_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
        prey$coord_prey[j]=prey$coord_prey[j]-1
        prey$pasos[j]=prey$pasos[j]+1
     }
    }
    }

 }



    if (prey$coord_prey[j]==1){

       current_cell_b=interpol2(fungi$biomass[1,i],0,K,0.01,1)
       left_cell_b=interpol2(fungi$biomass[World_size,i],0,K,0.01,1)
       right_cell_b=interpol2(fungi$biomass[1+1,i],0,K,0.01,1)



       current_cell_r=1/current_cell_b
       left_cell_r=1/left_cell_b
       right_cell_r=1/right_cell_b




    if (current_cell_b == 0.01&current_cell_b == left_cell_b&right_cell_b == left_cell_b)
    {
     salto <-round(runif(1,min=2,max=prey$search_area_tuned[j]+2),0)  ##"salto" means "jump" in Spanish, when the cells to the right and to the left have no fungi, they jump longer distances
     ##+2 to avoid NAs from max<min

         valor<-runif(1)
         if (valor>0.4999)
         ((prey$coord_prey[j]<-salto+1) &
         (prey$pasos[j]=salto))
         if (valor<=0.4999)
         ((prey$coord_prey[j]<-(World_size+1)-salto)&
         (prey$pasos[j]=salto))
    }else{
     if (right_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
         prey$coord_prey[j]=1+1
         prey$pasos[j]=prey$pasos[j]+1
    }else{
     if (left_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
        prey$coord_prey[j]=World_size
        prey$pasos[j]=prey$pasos[j]+1
     }
    }

    }
   }




    if (prey$coord_prey[j]>1&prey$coord_prey[j]<World_size){

       current_cell_b=interpol2(fungi$biomass[prey$coord_prey[j],i],0,K,0.01,1)
       left_cell_b=interpol2(fungi$biomass[prey$coord_prey[j]-1,i],0,K,0.01,1)
       right_cell_b=interpol2(fungi$biomass[prey$coord_prey[j]+1,i],0,K,0.01,1)


       current_cell_r=1/current_cell_b
       left_cell_r=1/left_cell_b
       right_cell_r=1/right_cell_b



       if (current_cell_b == 0.01&current_cell_b == left_cell_b&right_cell_b == left_cell_b)
    {
     salto <-round(runif(1,min=2,max=prey$search_area_tuned[j]+2),0)  ##"salto" means "jump" in Spanish, when the cells to the right and to the left have no fungi, they jump longer distances
     ##+2 to avoid NAs from max<min

         valor<-runif(1)
         if (valor>0.4999)
         ((prey$coord_prey[j]<-prey$coord_prey[j]+salto) &
         (prey$pasos[j]=salto))
         if (valor<=0.4999)
         ((prey$coord_prey[j]<-prey$coord_prey[j]-salto)&
         (prey$pasos[j]=salto))
         if (prey$coord_prey[j]>World_size)                    ##if jumping occurs outside the World, makes it to return to the other end
         prey$coord_prey[j]=prey$coord_prey[j]-World_size
         if (prey$coord_prey[j]<1)
         prey$coord_prey[j]=World_size+prey$coord_prey[j]


    }else{
     if (right_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
         prey$coord_prey[j]=prey$coord_prey[j]+1
         prey$pasos[j]=prey$pasos[j]+1
    }else{
     if (left_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
        prey$coord_prey[j]=prey$coord_prey[j]-1
        prey$pasos[j]=prey$pasos[j]+1
     }
    }

    }
   }
    return(prey)
  }
  }


  ####HERE FOR SIT-AND-WAIT WE HAVE INCLUDED NON-ADAPTIVELY MOVING PREY... HOWEVER, THIS WILL BE GOOD TO COMPARE SW VS AH
  ####FOR NOW, WE RETURNED TO ADAPTIVE ANTI-PREDATORY MOVEMENT
 if (predators==1 & adaptive==1){
  ###### prey moving algorithm when there ARE predators around - here the animals move to patches with more resources relative to predators (lowest predator_number/fungi_biomass)
  ###IMPORTANT: when there are predators around, prey show anti-predatory behaviour by avoiding cells (patches) with too many predators and low food
  prey_mov<-function(prey,pred,fungi,i,World_size,j)          ##pred information is also passed on to the function!!!!
  {
   #


    if (prey$coord_prey[j]==World_size){


       current_cell_b=interpol2(fungi$biomass[World_size,i],0,K,0.01,1)
       left_cell_b=interpol2(fungi$biomass[World_size-1,i],0,K,0.01,1)
       right_cell_b=interpol2(fungi$biomass[1,i],0,K,0.01,1)

       n_current=sum(pred$coord_pred==fungi$cells[World_size]&pred$alive==1) ###number of alive predators in current cell
       n_left=sum(pred$coord_pred==fungi$cells[World_size-1]&pred$alive==1) ###number of alive predators in left cell
       n_right=sum(pred$coord_pred==fungi$cells[1]&pred$alive==1) ###number of alive predators in right cell

       current_cell_p=interpol2(n_current,0,100,0.01,1)
       left_cell_p=interpol2(n_left,0,100,0.01,1)
       right_cell_p=interpol2(n_right,0,100,0.01,1)

       current_cell_r=current_cell_p/current_cell_b
       left_cell_r=left_cell_p/left_cell_b
       right_cell_r=right_cell_p/right_cell_b

    if (current_cell_b == 0.01&current_cell_b == left_cell_b&right_cell_b == left_cell_b)
    {
     salto <-round(runif(1,min=2,max=prey$search_area_tuned[j]+2),0)  ##"salto" means "jump" in Spanish, when the cells to the right and to the left have no fungi, they jump longer distances
     ##+2 to avoid NAs from max<min

         valor<-runif(1)
         if (valor>0.4999)
         ((prey$coord_prey[j]<-salto) &
         (prey$pasos[j]=salto))
         if (valor<=0.4999)
         ((prey$coord_prey[j]<-World_size-salto)&
         (prey$pasos[j]=salto))
    }else{
     if (right_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
         prey$coord_prey[j]=1
         prey$pasos[j]=prey$pasos[j]+1
    }else{
     if (left_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
        prey$coord_prey[j]=prey$coord_prey[j]-1
        prey$pasos[j]=prey$pasos[j]+1
     }
    }

    }
 }



    if (prey$coord_prey[j]==1){

       current_cell_b=interpol2(fungi$biomass[1,i],0,K,0.01,1)
       left_cell_b=interpol2(fungi$biomass[World_size,i],0,K,0.01,1)
       right_cell_b=interpol2(fungi$biomass[1+1,i],0,K,0.01,1)


       n_current=sum(pred$coord_pred==fungi$cells[1]&pred$alive==1) ###number of alive predators in current cell
       n_left=sum(pred$coord_pred==fungi$cells[World_size]&pred$alive==1) ###number of alive predators in left cell
       n_right=sum(pred$coord_pred==fungi$cells[1+1]&pred$alive==1) ###number of alive predators in right cell

       current_cell_p=interpol2(n_current,0,100,0.01,1)
       left_cell_p=interpol2(n_left,0,100,0.01,1)
       right_cell_p=interpol2(n_right,0,100,0.01,1)

       current_cell_r=current_cell_p/current_cell_b
       left_cell_r=left_cell_p/left_cell_b
       right_cell_r=right_cell_p/right_cell_b




  if (current_cell_b == 0.01&current_cell_b == left_cell_b&right_cell_b == left_cell_b)
    {
     salto <-round(runif(1,min=2,max=prey$search_area_tuned[j]+2),0)  ##"salto" means "jump" in Spanish, when the cells to the right and to the left have no fungi, they jump longer distances
     ##+2 to avoid NAs from max<min

         valor<-runif(1)
         if (valor>0.4999)
         ((prey$coord_prey[j]<-salto+1) &
         (prey$pasos[j]=salto))
         if (valor<=0.4999)
         ((prey$coord_prey[j]<-(World_size+1)-salto)&
         (prey$pasos[j]=salto))
    }else{
     if (right_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
         prey$coord_prey[j]=1+1
         prey$pasos[j]=prey$pasos[j]+1
    }else{
     if (left_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
        prey$coord_prey[j]=World_size
        prey$pasos[j]=prey$pasos[j]+1
     }
    }

    }
   }


    if (prey$coord_prey[j]>1&prey$coord_prey[j]<World_size){

       current_cell_b=interpol2(fungi$biomass[prey$coord_prey[j],i],0,K,0.01,1)
       left_cell_b=interpol2(fungi$biomass[prey$coord_prey[j]-1,i],0,K,0.01,1)
       right_cell_b=interpol2(fungi$biomass[prey$coord_prey[j]+1,i],0,K,0.01,1)

       n_current=sum(pred$coord_pred==fungi$cells[prey$coord_prey[j]]&pred$alive==1) ###number of alive predators in current cell
       n_left=sum(pred$coord_pred==fungi$cells[prey$coord_prey[j]-1]&pred$alive==1) ###number of alive predators in left cell
       n_right=sum(pred$coord_pred==fungi$cells[prey$coord_prey[j]+1]&pred$alive==1) ###number of alive predators in right cell

       current_cell_p=interpol2(n_current,0,100,0.01,1)
       left_cell_p=interpol2(n_left,0,100,0.01,1)
       right_cell_p=interpol2(n_right,0,100,0.01,1)

       current_cell_r=current_cell_p/current_cell_b
       left_cell_r=left_cell_p/left_cell_b
       right_cell_r=right_cell_p/right_cell_b


       if (current_cell_b == 0.01&current_cell_b == left_cell_b&right_cell_b == left_cell_b)
    {
     salto <-round(runif(1,min=2,max=prey$search_area_tuned[j]+2),0)  ##"salto" means "jump" in Spanish, when the cells to the right and to the left have no fungi, they jump longer distances
     ##+2 to avoid NAs from max<min

         valor<-runif(1)
         if (valor>0.4999)
         ((prey$coord_prey[j]<-prey$coord_prey[j]+salto) &
         (prey$pasos[j]=salto))
         if (valor<=0.4999)
         ((prey$coord_prey[j]<-prey$coord_prey[j]-salto)&
         (prey$pasos[j]=salto))
         if (prey$coord_prey[j]>World_size)                    ##if jumping occurs outside the World, makes it to return to the other end
         prey$coord_prey[j]=prey$coord_prey[j]-World_size
         if (prey$coord_prey[j]<1)
         prey$coord_prey[j]=World_size+prey$coord_prey[j]


    }else{
     if (right_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
         prey$coord_prey[j]=prey$coord_prey[j]+1
         prey$pasos[j]=prey$pasos[j]+1
    }else{
     if (left_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
        prey$coord_prey[j]=prey$coord_prey[j]-1
        prey$pasos[j]=prey$pasos[j]+1
     }
    }

    }
   }

   return(prey)
  }
  }



  ### prey feeding algorithm
  ### these fungivore prey feed with a satiation limit (upper_tank) and the amount of food depend on the "tuned voracity" and the "fixed" body size ("energy tank" not cosidered)
  feed_prey<-function(prey,i,fungi,par_food,eficiencia,upper_tank_prey,r)
  {

    if(prey$alive[r]==1){
    prey$critical[r]<-prey$energy_tank[r]/prey$body_size[r]


      if ((prey$search_area_tuned[r]>0)){    ## (prey$critical[r]<upper_tank_prey)&&

      prey$eaten[r]<-prey$voracity_tuned[r]

      if (prey$eaten[r]>=fungi$biomass[prey$coord_prey[r],i])
      prey$eaten[r]=fungi$biomass[prey$coord_prey[r],i]
      if (prey$eaten[r]<0)
      prey$eaten[r]=0
      if (fungi$biomass[prey$coord_prey[r],i]==0)
      prey$eaten[r]=0

      #print(prey$eaten[r])

      prey$energy_tank[r]=prey$energy_tank[r]+prey$assim[r]*prey$eaten[r]
      prey$critical[r]<-prey$energy_tank[r]/prey$body_size[r]
      }else{
      prey$eaten[r]=0
      }



  }
      return(prey)
  }


  ##### fungi fed function
  ##this merely updates the fungi according to what animals have eaten this day
  fungi_eaten<-function(prey,i,fungi,r,min_fungi,zero_fungi)
  {



      if (prey$eaten[r]>=fungi$biomass[prey$coord_prey[r],i]){
      fungi$biomass[prey$coord_prey[r],i]=0
      fungi$biomass_out[prey$coord_prey[r],i]=fungi$biomass_out[prey$coord_prey[r],i]+prey$eaten[r]
      }



      if (prey$eaten[r]<fungi$biomass[prey$coord_prey[r],i]){
      fungi$biomass[prey$coord_prey[r],i]=fungi$biomass[prey$coord_prey[r],i]-prey$eaten[r]
      fungi$biomass_out[prey$coord_prey[r],i]=fungi$biomass_out[prey$coord_prey[r],i]+prey$eaten[r]
      }


      if (fungi$biomass[prey$coord_prey[r],i]<=min_fungi/zero_fungi){
      fungi$biomass[prey$coord_prey[r],i]=0
      }



      return(fungi)
  }



  ###METABOLIC LOST - it has three components: bmr - basal metabolic rate, fmr - field metabolic rate and smr, sprint metabolic rate.
  ##bmr is lost when the animal is not moving
  ##fmr is lost according to the actual number of cells that the animal has moved
  ##smr is lost depending on the number of encounters with predators or prey (of course if successful escaping has occurred in the case of prey)
  metab_with_growth<-function(x,i,assigned,ss,deadly_tank,upper_tank)     ##metabolic cost plus death from energetic maintenance + growth function
  {

    TK=T+273.15 ##0C in Kelvin plus T in C
    ##### 7000 J/g

    if(x$alive[ss]==1){

    mass_in_mg=(x$body_size[ss]+x$energy_tank[ss])

    for_stress=interpol2(x$encounters_pred[ss],0,max_encs_T,0,0.407)  ##Hawlena et al. 2010 PNAS


    if(predators==1)
    if(x$pred_prey[ss]=="pred"){ ##mesostigmata parameters from Ehnes et al. 2011 Ecol Lett
    constant=-7.2945+43.966*x$actE_met[ss]
    #print(constant)
    basal_met_tax=exp(constant+x$met_rate[ss]*log(mass_in_mg)-x$actE_met[ss]*(1/(TK*0.0000862)))
    fraction_with_stress=for_stress*basal_met_tax
    field_met_tax=3*basal_met_tax  # from Brose et al. JAE, variation between spiders and carabids -> intercept is for spiders.
    prop_time_mov=((x$pasos[ss]/max_search_area_T)+(x$voracity_tuned[ss]/max_voracity_pred_T))/2   ##calculates the proportion of time moving around, which depends on voracity and actual number of "pasos" (number of cells moved in one day).
    }

    if(x$pred_prey[ss]=="prey"){ ##insecta parameters from Ehnes et al. 2011 Ecol Lett
    constant=-7.2945+43.966*x$actE_met[ss]
    basal_met_tax=exp(constant+x$met_rate[ss]*log(mass_in_mg)-x$actE_met[ss]*(1/(TK*0.0000862)))
    fraction_with_stress=for_stress*basal_met_tax
    field_met_tax=3*basal_met_tax  # from Brose et al. JAE, variation between spiders and carabids -> intercept is for spiders.
    prop_time_mov=((x$pasos[ss]/max_search_area_T)+(x$voracity_tuned[ss]/max_voracity_prey_T))/2   ##calculates the proportion of time moving around, which depends on voracity and actual number of "pasos" (number of cells moved in one day).
    }


    basal_met_tax=basal_met_tax+fraction_with_stress

    loss_from_bmr_s=(1-prop_time_mov)*basal_met_tax  ##in Joules    ##The proportion of time resting is 1-proportion_of_time_moving
    loss_from_fmr_s=prop_time_mov*field_met_tax

    #print(loss_from_bmr_s+loss_from_fmr_s) ##J/s as in Brose et al. 2008

    loss_from_bmr=(1-prop_time_mov)*basal_met_tax*24    ##in Joules    ##The proportion of time resting is 1-proportion_of_time_moving
    loss_from_fmr=prop_time_mov*field_met_tax*24   ##

    loss_from_bmr=loss_from_bmr/7  ##losses in mg
    loss_from_fmr=loss_from_fmr/7
    
    ###Calculating digestion times for predators
    if(predators==1)
    if(x$pred_prey[ss]=="pred"){

    if(x$eating[ss]>0){
    
#    vor_interc<-interpol2(x$voracity[ss],0.55,0.75,0.05,0.15)
#    max_day=vor_interc*(x$body_size[ss]+x$energy_tank[ss])^x$voracity[ss]
    x$days_digest[ss]<-as.integer(ceiling(x$food_mass[ss]/x$voracity_tuned[ss]))
    x$days_digest[ss]<-as.integer(ceiling(x$days_digest[ss]*interpol2(T,min_T,max_T,1,Q10digest)))
  #  print("days_digesting")
  #  print(x$days_digest[ss])
    }

  
    }

    x$energy_tank[ss]=x$energy_tank[ss]-loss_from_bmr-loss_from_fmr   ##the energy lost is substracted from the energy tank (mg)
 
    ###death from starvation?
    x$critical[ss]<-x$energy_tank[ss]/x$body_size[ss]
    if (x$critical[ss]<deadly_tank){          ##if critical is below this threshold the animal dies from starvation
    x$alive[ss]=2
    x$date_death[ss]=i
    }

    ###is an animal ready to moult?
    if (x$alive[ss]==1&x$instar[ss]<4){
    body_mass=x$body_size[ss]+x$energy_tank[ss]
    
    ini_mass=x$body_size[ss]+x$tank_ini[ss]*x$body_size[ss]
    
    investment=body_mass*assigned
    
    if (x$pred_prey[ss]=="prey"){
    a=0.0056 ##Gruner parameters/ Hodar a=0.0024 b=3.676
    b=2.809
    total_L=((0.3*ini_mass)/a)^(1/b)            ###0.3 to control for dry body mass
    next_L=x$growth[ss]*total_L
    next_M=(a*next_L^b)/0.3 ###to reconvert it to wet mass
    next_size=next_M/(1+x$tank_ini[ss])
    next_tank=next_size*x$tank_ini[ss]
   
 #   print("investment larger than next_M?")
#    print(c(investment,next_M))
    if (investment>=next_M){   ###it is ready to molt
    x$body_size[ss]=next_size
    x$energy_tank[ss]=(next_tank)+(investment-next_M) ##the second term adds the excess of energy to the new tank

    x$critical[ss]=x$energy_tank[ss]/x$body_size[ss]
    x$instar[ss]=x$instar[ss]+1
    
    }
    }
    
    
    if (x$pred_prey[ss]=="pred"){
    a=0.0629 ##Edwards parameters/ Hodar a=0.1044 b=2.296 + 70h2o so function needs to be with 0.3 and so on like in prey
    b=2.53
    total_L=(ini_mass/a)^(1/b)
    next_L=x$growth[ss]*total_L
    next_M=a*next_L^b
    next_size=next_M/(1+x$tank_ini[ss])
    next_tank=next_size*x$tank_ini[ss]
   
    if (investment>=next_M){   ###it is ready to molt
    x$body_size[ss]=next_size
    x$energy_tank[ss]=(next_tank)+(investment-next_M) ##the second term adds the excess of energy to the new tank

    x$critical[ss]=x$energy_tank[ss]/x$body_size[ss]
    x$instar[ss]=x$instar[ss]+1
    
    }
    }

    

    
    }

    ###is a prey ready to reproduce?
    if (x$alive[ss]==1&x$pred_prey[ss]=="prey"&x$instar[ss]>=4){
    body_mass=x$body_size[ss]+x$energy_tank[ss]
    ini_mass=x$body_size[ss]+x$tank_ini[ss]*x$body_size[ss]
    
    investment=body_mass*assigned
    if(investment>=2*x$body_size[ss]){#safe_starv_prey*next_M){      ###If the prey has reached adulthood and has enough energy, reproduces
    x$alive[ss]=4                        ##1.2 to diminish starvation after reproduction
    }

    }

    ###is a predator ready to reproduce?
    if(predators==1)
    if (x$alive[ss]==1&x$pred_prey[ss]=="pred"&x$instar[ss]>=4){
    body_mass=x$body_size[ss]+x$energy_tank[ss]
        
    if(body_mass>=2*x$body_size[ss]){      ###If the pred has reached adulthood and has enough energy (twice as much of its fixed size), reproduces
    x$alive[ss]=4                        ##1.2 to diminish starvation after reproduction
    }

    }


    }

    return(x)
  }


  ###this function tunes voracity (how much food the animal eats) and search area (maximum number of cells visited)
  ###according to condition (how much energy does the animal have stored)
  ###if condition is better, the animal will feed less and move less (something I have data from my spiders and PhD Thesis, although here the actual values are guessed)
  tune_traits<-function(x,upper_tank)
  {
    
    dead_tank<-matrix(nrow=nrow(x),ncol=1,deadly_tank)
    
    a_prey=0.0056
    b_prey=2.809
    a_pred=0.0629
    b_pred=2.53

    body_mass=x$body_size+x$energy_tank
    ini_mass=x$body_size+x$tank_ini*x$body_size
   
    investment=body_mass*assigned
    
    total_L<-ifelse(x$pred_prey=="prey",((0.3*ini_mass)/a_prey)^(1/b_prey),(ini_mass/a_pred)^(1/b_pred)) 
    next_L=x$growth*total_L
    next_M<-ifelse(x$pred_prey=="prey",(a_prey*next_L^b_prey)/0.3,a_pred*next_L^b_pred) 
    
    up_energy=(next_M/assigned)-x$body_size
    up_tank=up_energy/x$body_size
    
    x$critical<-x$energy_tank/x$body_size
       
    x$condition<-interpol2(x$critical,dead_tank,up_tank,1,0.1)
  
    x$condition<-ifelse(x$condition>1,1,x$condition)
    x$condition<-ifelse(x$condition<0.1,0.1,x$condition)
    
    

    ####new method to improve naive coefficients
    srch_interc<-matrix(nrow=nrow(x),ncol=1)
    srch_interc<-interpol2(x$search_area,0.05,0.5,1,10) 
    x$search_area_tuned<-srch_interc*(x$body_size+x$energy_tank)^x$search_area
    
    ##x$search_area_tuned<-x$condition*x$search_area_tuned ##this maintains the coefficient higher for better condition so search_area will be lower as MASS<1mg
    

     
    vor_interc<-matrix(nrow=nrow(x),ncol=1)
    vor_interc<-interpol2(x$voracity,0.55,0.75,0.05,0.15)
    x$voracity_tuned<-vor_interc*(x$body_size+x$energy_tank)^x$voracity
    
    ###x$voracity_tuned<-round(x$condition*x$voracity_tuned,4) ##this maintains the coefficient higher for better condition so voracity will be lower as MASS<1mg

    spd_interc<-matrix(nrow=nrow(x),ncol=1)
    spd_interc<-interpol2(x$speed_ini,0.05,0.35,1,7)
    x$speed<-spd_interc*(x$body_size+x$energy_tank)^x$speed_ini

    x$speed<-x$condition*x$speed 


   return(x)
  }

  ###this function tunes voracity (how much food the animal eats) and search area (maximum number of cells visited)
  ###according to the previous number of encounters with predators animals have higher or lower voracity and mobility
  ###if one animal has encountered many predators (the environment is dangerous), the animal will feed less and move less
  ###This is thus a second level of antipredatory behaviour
  tune_traits2<-function(x)
  {
    
    x$encounters_0_1<-interpol2(x$encounters_pred,0,max_encs_T,1,0.1) ##inverse interpolation here too
    x$encounters_0_1<-ifelse(x$encounters_0_1>1,1,x$encounters_0_1)
    x$encounters_0_1<-ifelse(x$encounters_0_1<0.1,0.1,x$encounters_0_1)

    x$assim<-interpol2(x$encounters_pred,0,max_encs_T,0,0.76) ##assim max reduction = 76% - Trussell et al. 2006 Ecology 87:2979-2984.
    x$assim<-ifelse(x$assim>0.76,0.76,x$assim)
    x$assim<-ifelse(x$assim<0,0,x$assim)
  

    ####x$voracity_tuned<-x$encounters_0_1*x$voracity_tuned
    
    x$voracity_tuned<-round(((x$condition+x$encounters_0_1)/2)*x$voracity_tuned,4)
    
    ##print(c(x$condition,x$encounters_0_1))
    
    
    ###x$voracity_tuned<-round(x$condition*x$encounters_0_1*x$voracity_tuned,4)

    x$search_area_tuned<-as.integer(round(((x$condition+x$encounters_0_1)/2)*x$search_area_tuned,0))
    x$search_area_tuned<-ifelse(x$search_area_tuned<=0,0,x$search_area_tuned)
    x$search_area_tuned<-as.integer(round(x$search_area_tuned,0))

    x$assim<-x$assim_ini-(x$assim*x$assim_ini) ###this is the amount of reduction necessary in assimilation!!!!

    x$voracity_tuned<-x$voracity_tuned*interpol2(T,min_T,max_T,1,x$vorQ10)
    
    x$search_area_tuned<-as.integer(round(x$search_area_tuned*interpol2(T,min_T,max_T,1,x$srchQ10),0))
    
    print(x$search_area_tuned)
      
#    x$search_area_tuned<-ifelse(x$pred_prey=="prey",as.integer(round(x$search_area_tuned*interpol2(T,min_T,max_T,1,x$srchQ10),0)),as.integer(1)) ##so predators move at least once
#    
#    x$search_area_tuned<-ifelse((x$pred_prey=="pred")&&(x$energy_tank/x$body_size)<=0.3,as.integer(7),x$search_area_tuned)  ###for sit-and-wait to relocate the web
   
    
    
    x$speed<-x$speed*interpol2(T,min_T,max_T,1,x$spdQ10)   ##15 is the minimum temperature for the simulations

  return(x)
  }


  ##this function just measures how many (and which) predators a prey finds in each cell that moves in
  for_interaction<-function(pred,prey,fungi,i,j)
  {
  n_preds_in_cell=sum(pred$coord_pred==fungi$cells[prey$coord_prey[j]]&pred$alive==1&pred$eating==0&pred$days_digest==0)   #&pred$body_size>prey$body_size[j]

  if(n_preds_in_cell>0){
  candidates<-subset(pred,coord_pred==fungi$cells[prey$coord_prey[j]]&pred$alive==1&pred$eating==0&pred$days_digest==0)  ##&pred$body_size>prey$body_size[j]
  pred_traits<-cbind(candidates$ID,candidates$body_size,candidates$voracity_tuned,candidates$speed,candidates$energy_tank,candidates$alive,candidates$date_death)
  
  prey_traits<-cbind(prey$ID[j],prey$body_size[j],prey$voracity_tuned[j],prey$speed[j],prey$energy_tank[j],prey$alive[j],prey$date_death[j])
  
  in_cell<-as.data.frame(rbind(prey_traits,pred_traits))
  names(in_cell)<-c("ID","body_size","voracity_tuned","speed","energy_tank","alive","date_death")
  
  in_cell$p_encounter<-0#as.data.frame(matrix(nrow=nrow(in_cell),ncol=1,0))
  
  in_cell$p_predation<-0

  
  in_cell$eating<-0
  in_cell$food_mass<-0

  in_cell$encounters_pred<-0
  in_cell$encounters_prey<-0

  in_cell$eating[2:(n_preds_in_cell+1)]<-candidates$eating[1:n_preds_in_cell]
  in_cell$food_mass[2:(n_preds_in_cell+1)]<-candidates$food_mass[1:n_preds_in_cell]

  }else{
  in_cell<-vector(length=0) ##so in_cell is something, albeit not quite
  }
  return(in_cell)
  }


  ### this counts whether predators in a cell are found (there is an actual encounter) by the moving prey and whether predation occurs by each of them
  ### encounter depends on the voracity of the prey, the voracity of the predator and the sum of predator and prey body sizes
  ### predation depends on the ratio of body sizes, the voracity of the predator and the ratio of sprint speeds.
  ### predation depends on the ratio of body sizes, the voracity of the predator and the ratio of sprint speeds.
  predation_prey_move<-function(in_cell,i)
  {
    ###the following parameters are newly added to standardize the predictors in encounter and predation probabilities (file: trait_parameterization...xls)
   
  
  n_preds_in_cell=nrow(in_cell)-1
  if (n_preds_in_cell>0){
  z=1
  while (in_cell$alive[1]==1&z<=n_preds_in_cell){           ##the targeted prey is always in position 1

    vor_1=(in_cell$voracity_tuned[1]-mean_vor_prey)/sd_vor_prey
  
    vor_z_1=(in_cell$voracity_tuned[z+1]-mean_vor_pred)/sd_vor_pred
    
    size_z_1=(in_cell$body_size[z+1]-mean_size_pred)/sd_size_pred
    
    size_1=(in_cell$body_size[1]-mean_size_prey)/sd_size_prey
    
    size_x_size=(in_cell$body_size[z+1]*in_cell$body_size[1]-mean_size_x_size)/sd_size_x_size
    
    vor_x_vor=(in_cell$voracity_tuned[z+1]*in_cell$voracity_tuned[1]-mean_vor_x_vor)/sd_vor_x_vor


    if (mode=="sw"){
    in_cell$p_encounter[z+1]=(1/(1+exp(-1*(1+0.05*vor_1+          ##vor predator X10 
              0.2*vor_z_1+0.2*vor_x_vor+
              0.05*size_z_1+0.05*size_1+0.05*size_x_size))))
              }
    if (mode=="ah"){
    in_cell$p_encounter[z+1]=(1/(1+exp(-1*(1+0.1*vor_1+          ##vor predator X10 
              0.1*vor_z_1+0.1*vor_x_vor+
              0.1*size_z_1+0.1*size_1+0.1*size_x_size))))
              }
    
              

  if(in_cell$p_encounter[z+1]<0) in_cell$p_encounter[z+1]=0
  if(in_cell$p_encounter[z+1]>1) in_cell$p_encounter[z+1]=1
  
 print("p_encounter")
 print(in_cell$p_encounter[z+1])
#
    if (in_cell$p_encounter[z+1]>runif(1,min=0,max=1)){    ##if encounter occurs 

    in_cell$encounters_pred[1]=in_cell$encounters_pred[1]+1
    in_cell$encounters_prey[z+1]=in_cell$encounters_prey[z+1]+1

    vor_z_1=(in_cell$voracity_tuned[z+1]-mean_vor_pred)/sd_vor_pred

  spd_ratio=((in_cell$speed[z+1]/in_cell$speed[1])-mean_spd_ratio)/sd_spd_ratio

  size_ratio=((in_cell$body_size[z+1]/in_cell$body_size[1])-mean_size_ratio)/sd_size_ratio

  if (mode=="sw"){
  in_cell$p_predation[z+1]=(1/(1+exp(-1*(1+#+1*(spd_ratio)             ##spd_ratio does not matter anymore  
                          0.3*vor_z_1+                    
                          0.001*(size_ratio)))))       ###size ratio counts much less /10
  }
  if (mode=="ah"){
  in_cell$p_predation[z+1]=(1/(1+exp(-1*(1+0.1*(spd_ratio)+             ##spd_ratio does not matter anymore  
                          0.1*vor_z_1+                     
                          0.1*(size_ratio)))))       ###size ratio counts much less /10
  }


        if(in_cell$p_predation[z+1]<0) in_cell$p_predation[z+1]=0
        if(in_cell$p_predation[z+1]>1) in_cell$p_predation[z+1]=1



    print("p_predation")
    print(in_cell$p_predation[z+1])
#
    if (in_cell$p_predation[z+1]>runif(1,min=control_attack_rate,max=1)){    ##if predation occurs
    in_cell$alive[1]=3    ##death from predation
    in_cell$date_death[1]=i
    in_cell$eating[z+1]=1
    in_cell$food_mass[z+1]<-in_cell$body_size[1]+in_cell$energy_tank[1]

    }
   }
  z=z+1
  }
  }
  return(in_cell)
  }

  ### how much energy a prey eaten is converted into predator own mass (depends on the assim trait)
  pred_assim<-function(pred,r,upper_tank_pred)
  {
    if(pred$alive[r]==1){
    pred$critical[r]<-pred$energy_tank[r]/pred$body_size[r]

#      if (pred$food_mass[r]>pred$voracity_tuned[r]){
#      pred$food_mass[r]<-pred$voracity_tuned[r]
#      }
#
      pred$energy_tank[r]=pred$energy_tank[r]+pred$assim[r]*pred$food_mass[r]
      pred$critical[r]<-pred$energy_tank[r]/pred$body_size[r]



  }
      return(pred)
  }

  #



  ####FOR SIT-AND-WAIT SPIDERS THIS FUNCTION HAS CHANGED ACCORDING TO CONDITION
    if (predators==1){
  ###### pred moving algorithm
  ###### as with prey and fungi, predators move to cells where there are more prey.

  ##### THIS NEW ALGORITHM ASSUMES THAT PREDATORS MOVE AWAY FROM OTHER PREDATORS (THEY DO NOT SEEK FOR PREDATORS EVEN THOUGH THEY COULD EAT THEM) AND SEEK FOR PREY
  pred_mov<-function(prey,pred,fungi,i,World_size,j)          ##prey information is also passed on to the function!!!!
  {
   #
    if (mode=="ah" | (mode=="sw" & pred$energy_tank[j]/pred$body_size[j]<0.3)){

    if (pred$coord_pred[j]==World_size){


       prey_current=sum(prey$coord_prey==fungi$cells[World_size]&prey$alive==1) ###number of alive prey in current cell
       prey_left=sum(prey$coord_prey==fungi$cells[World_size-1]&prey$alive==1) ###number of alive prey in left cell
       prey_right=sum(prey$coord_prey==fungi$cells[1]&prey$alive==1) ###number of alive preyin right cell

       pred_current=sum(pred$coord_pred==fungi$cells[World_size]&pred$alive==1)-1 ###number of alive predators in current cell
       pred_left=sum(pred$coord_pred==fungi$cells[World_size-1]&pred$alive==1)-1 ###number of alive predators in left cell
       pred_right=sum(pred$coord_pred==fungi$cells[1]&pred$alive==1)-1 ###number of alive predators in right cell

       if(pred_current<0) pred_current=0
       if(pred_left<0) pred_left=0
       if(pred_right<0) pred_right=0

       current_cell_prey=interpol2(prey_current,0,100,0.01,1)
       left_cell_prey=interpol2(prey_left,0,100,0.01,1)
       right_cell_prey=interpol2(prey_right,0,100,0.01,1)

       current_cell_pred=interpol2(pred_current,0,100,0.01,1)
       left_cell_pred=interpol2(pred_left,0,100,0.01,1)
       right_cell_pred=interpol2(pred_right,0,100,0.01,1)

       current_cell_r=current_cell_pred/current_cell_prey
       left_cell_r=left_cell_pred/left_cell_prey
       right_cell_r=right_cell_pred/right_cell_prey

   if (current_cell_prey == 0.01&current_cell_prey == left_cell_prey&right_cell_prey == left_cell_prey)
    {
     salto <-round(runif(1,min=2,max=pred$search_area_tuned[j]+2),0)  ##"salto" means "jump" in Spanish, when the cells to the right and to the left have no fungi, they jump longer distances
     ##+2 to avoid NAs from max<min

         valor<-runif(1)
         if (valor>0.4999)
         ((pred$coord_pred[j]<-salto) &
         (pred$pasos[j]=salto))
         if (valor<=0.4999)
         ((pred$coord_pred[j]<-World_size-salto)&
         (pred$pasos[j]=salto))
    }else{
     if (right_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
         pred$coord_pred[j]=1
         pred$pasos[j]=pred$pasos[j]+1
    }else{
     if (left_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
        pred$coord_pred[j]=pred$coord_pred[j]-1
        pred$pasos[j]=pred$pasos[j]+1
     }
    }

    }

  }



    if (pred$coord_pred[j]==1){


       prey_current=sum(prey$coord_prey==fungi$cells[1]&prey$alive==1) ###number of alive prey in current cell
       prey_left=sum(prey$coord_prey==fungi$cells[World_size]&prey$alive==1) ###number of alive prey in left cell
       prey_right=sum(prey$coord_prey==fungi$cells[1+1]&prey$alive==1) ###number of alive prey in right cell

       pred_current=sum(pred$coord_pred==fungi$cells[1]&pred$alive==1)-1 ###number of alive predators in current cell
       pred_left=sum(pred$coord_pred==fungi$cells[World_size]&pred$alive==1)-1 ###number of alive predators in left cell
       pred_right=sum(pred$coord_pred==fungi$cells[1+1]&pred$alive==1)-1 ###number of alive predators in right cell

       if(pred_current<0) pred_current=0
       if(pred_left<0) pred_left=0
       if(pred_right<0) pred_right=0


       current_cell_prey=interpol2(prey_current,0,100,0.01,1)
       left_cell_prey=interpol2(prey_left,0,100,0.01,1)
       right_cell_prey=interpol2(prey_right,0,100,0.01,1)

       current_cell_pred=interpol2(pred_current,0,100,0.01,1)
       left_cell_pred=interpol2(pred_left,0,100,0.01,1)
       right_cell_pred=interpol2(pred_right,0,100,0.01,1)

       current_cell_r=current_cell_pred/current_cell_prey
       left_cell_r=left_cell_pred/left_cell_prey
       right_cell_r=right_cell_pred/right_cell_prey


    if (current_cell_prey == 0.01&current_cell_prey == left_cell_prey&right_cell_prey == left_cell_prey)
    {
     salto <-round(runif(1,min=2,max=pred$search_area_tuned[j]+2),0)  ##"salto" means "jump" in Spanish, when the cells to the right and to the left have no fungi, they jump longer distances
     ##+2 to avoid NAs from max<min

         valor<-runif(1)
         if (valor>0.4999)
         ((pred$coord_pred[j]<-salto+1) &
         (pred$pasos[j]=salto))
         if (valor<=0.4999)
         ((pred$coord_pred[j]<-(World_size+1)-salto)&
         (pred$pasos[j]=salto))
    }else{
     if (right_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
         pred$coord_pred[j]=1+1
         pred$pasos[j]=pred$pasos[j]+1
    }else{
     if (left_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
        pred$coord_pred[j]=World_size
        pred$pasos[j]=pred$pasos[j]+1
     }
    }

    }

   }


    if (pred$coord_pred[j]>1&pred$coord_pred[j]<World_size){

       prey_current=sum(prey$coord_prey==fungi$cells[pred$coord_pred[j]]&prey$alive==1) ###number of alive prey in current cell
       prey_left=sum(prey$coord_prey==fungi$cells[pred$coord_pred[j]-1]&prey$alive==1) ###number of alive prey in left cell
       prey_right=sum(prey$coord_prey==fungi$cells[pred$coord_pred[j]+1]&prey$alive==1) ###number of alive preyin right cell

       pred_current=sum(pred$coord_pred==fungi$cells[pred$coord_pred[j]]&pred$alive==1)-1 ###number of alive predators in current cell
       pred_left=sum(pred$coord_pred==fungi$cells[pred$coord_pred[j]-1]&pred$alive==1)-1 ###number of alive predators in left cell
       pred_right=sum(pred$coord_pred==fungi$cells[pred$coord_pred[j]+1]&pred$alive==1)-1 ###number of alive predators in right cell

       if(pred_current<0) pred_current=0
       if(pred_left<0) pred_left=0
       if(pred_right<0) pred_right=0


       current_cell_prey=interpol2(prey_current,0,100,0.01,1)
       left_cell_prey=interpol2(prey_left,0,100,0.01,1)
       right_cell_prey=interpol2(prey_right,0,100,0.01,1)

       current_cell_pred=interpol2(pred_current,0,100,0.01,1)
       left_cell_pred=interpol2(pred_left,0,100,0.01,1)
       right_cell_pred=interpol2(pred_right,0,100,0.01,1)

       current_cell_r=current_cell_pred/current_cell_prey
       left_cell_r=left_cell_pred/left_cell_prey
       right_cell_r=right_cell_pred/right_cell_prey


      if (current_cell_prey == 0.01&current_cell_prey == left_cell_prey&right_cell_prey == left_cell_prey)
    {
     salto <-round(runif(1,min=2,max=pred$search_area_tuned[j]+2),0)  ##"salto" means "jump" in Spanish, when the cells to the right and to the left have no fungi, they jump longer distances
     ##+2 to avoid NAs from max<min

         valor<-runif(1)
         if (valor>0.4999)
         ((pred$coord_pred[j]<-pred$coord_pred[j]+salto) &
         (pred$pasos[j]=salto))
         if (valor<=0.4999)
         ((pred$coord_pred[j]<-pred$coord_pred[j]-salto)&
         (pred$pasos[j]=salto))
         if (pred$coord_pred[j]>World_size)                    ##if jumping occurs outside the World, makes it to return to the other end
         pred$coord_pred[j]=pred$coord_pred[j]-World_size
         if (pred$coord_pred[j]<1)
         pred$coord_pred[j]=World_size+pred$coord_pred[j]

    }else{
     if (right_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
         pred$coord_pred[j]=pred$coord_pred[j]+1
         pred$pasos[j]=pred$pasos[j]+1
    }else{
     if (left_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
        pred$coord_pred[j]=pred$coord_pred[j]-1
        pred$pasos[j]=pred$pasos[j]+1
     }
    }

    }

   }

  }
  
  
  
   return(pred)
  }
  
  
  
  }


##soso_start##    this is a for_interaction function for predators that risk being eaten by other predators when being in a patch

  ##this function just measures how many (and which) predators a prey find in each cell that moves in
  for_interaction_x1<-function(pred,fungi,j) ##remember to pass this from the main function... prey won't be getting here
  {
  n_preds_in_cell=sum(pred$coord_pred==fungi$cells[pred$coord_pred[j]]&pred$alive==1&pred$eating==0&pred$days_digest==0)-1   ##&pred$body_size>pred$body_size[j] number of active predators other than j
  
  if(n_preds_in_cell>0){
  candidates<-subset(pred,coord_pred==fungi$cells[pred$coord_pred[j]]&pred$alive==1&pred$eating==0&pred$ID!=pred$ID[j]&pred$days_digest==0)  ##&pred$body_size>pred$body_size[j] which predators can feed upon the target predator
  
  pred_traits<-cbind(candidates$ID,candidates$body_size,candidates$voracity_tuned,candidates$speed,candidates$energy_tank,candidates$alive,candidates$date_death)
  
  prey_traits<-cbind(pred$ID[j],pred$body_size[j],pred$voracity_tuned[j],pred$speed[j],pred$energy_tank[j],pred$alive[j],pred$date_death[j]) ##prey_traits because predator acts as prey
  
  in_cell_x1<-as.data.frame(rbind(prey_traits,pred_traits))
  names(in_cell_x1)<-c("ID","body_size","voracity_tuned","speed","energy_tank","alive","date_death")
  
  in_cell_x1$p_encounter<-0#as.data.frame(matrix(nrow=nrow(in_cell),ncol=1,0))
  
  in_cell_x1$p_predation<-0

  
  in_cell_x1$eating<-0
  in_cell_x1$food_mass<-0

  in_cell_x1$encounters_pred<-0
  in_cell_x1$encounters_prey<-0

  
  in_cell_x1$eating[2:(n_preds_in_cell+1)]<-candidates$eating[1:n_preds_in_cell]
  in_cell_x1$food_mass[2:(n_preds_in_cell+1)]<-candidates$food_mass[1:n_preds_in_cell]

  }else{
  in_cell_x1<-vector(length=0) ##so in_cell is something, albeit not quite
  }
  return(in_cell_x1)     ###this can be sent to predation_prey_move just like that and will return in_cell which will be really in_cell_x1
  }



  ###same as with prey above (for_interaction) but now are predators that are moving around searching for prey
  ###here predators feed on predators too!!!!!
  for_interaction2_x1<-function(pred,prey,fungi,j)
  {
  if(pred$eating[j]==0&pred$alive[j]==1){
  n_preys_in_cell=sum(prey$coord_prey==fungi$cells[pred$coord_pred[j]]&prey$alive==1)#&pred$body_size[j]>prey$body_size)
  n_preds_in_cell=sum(pred$coord_pred==fungi$cells[pred$coord_pred[j]]&pred$alive==1&pred$days_digest==0)-1     #&pred$body_size[j]>pred$body_size
  n_total=n_preys_in_cell+n_preds_in_cell
  
  if(n_total>0){
  if (n_preys_in_cell>0)
  candidates1<-subset(prey,coord_prey==fungi$cells[pred$coord_pred[j]]&prey$alive==1)       #&pred$body_size[j]>prey$body_size
  if (n_preds_in_cell>0)
  candidates2<-subset(pred,coord_pred==fungi$cells[pred$coord_pred[j]]&pred$alive==1&pred$ID!=pred$ID[j]&pred$days_digest==0)   #&pred$body_size[j]>pred$body_size
  if (n_preys_in_cell>0)
  prey_traits1<-cbind(candidates1$pred_prey,candidates1$ID,candidates1$body_size,candidates1$voracity_tuned,candidates1$speed,candidates1$energy_tank,candidates1$alive,candidates1$date_death)
  if (n_preds_in_cell>0)
  prey_traits2<-cbind(candidates2$pred_prey,candidates2$ID,candidates2$body_size,candidates2$voracity_tuned,candidates2$speed,candidates2$energy_tank,candidates2$alive,candidates2$date_death) #these are really predators

  pred_traits<-cbind(pred$pred_prey[j],pred$ID[j],pred$body_size[j],pred$voracity_tuned[j],pred$speed[j],pred$energy_tank[j],pred$alive[j],pred$date_death[j])
  
  if (n_preys_in_cell>0&n_preds_in_cell>0){
  in_cell2<-as.data.frame(rbind(pred_traits,prey_traits1,prey_traits2))
  }else{
  if (n_preys_in_cell>0){
  in_cell2<-as.data.frame(rbind(pred_traits,prey_traits1))
  }else{
  in_cell2<-as.data.frame(rbind(pred_traits,prey_traits2))
  }
  }

  
  names(in_cell2)<-c("pred_prey","ID","body_size","voracity_tuned","speed","energy_tank","alive","date_death")
  
  in_cell2$p_encounter<-0#as.data.frame(matrix(nrow=nrow(in_cell),ncol=1,0))
  
  in_cell2$p_predation<-0

  
  in_cell2$eating<-0
  in_cell2$food_mass<-0

  in_cell2$encounters_prey<-0
  in_cell2$encounters_pred<-0


  in_cell2$pred_prey<-as.character(in_cell2$pred_prey)
  in_cell2$ID<-as.integer(as.character(in_cell2$ID))
  in_cell2$body_size<-as.numeric(as.character(in_cell2$body_size))
  in_cell2$voracity_tuned<-as.numeric(as.character(in_cell2$voracity_tuned))
  in_cell2$speed<-as.numeric(as.character(in_cell2$speed))
  in_cell2$energy_tank<-as.numeric(as.character(in_cell2$energy_tank))
  in_cell2$alive<-as.integer(as.character(in_cell2$alive))
  in_cell2$date_death<-as.integer(as.character(in_cell2$date_death))

 
  }else{
  in_cell2<-vector(length=0) ##so in_cell is something, albeit not quite
  }
  }
  return(in_cell2)
  }



predation_pred_move<-function(in_cell2,i)
  {
    ###the following parameters are newly added to standardize the predictors in encounter and predation probabilities (file: trait_parameterization...xls)
  n_preys_in_cell=nrow(in_cell2)-1
  if (n_preys_in_cell>0){
  z=1
  while (in_cell2$alive[1]==1&z<=n_preys_in_cell){           ##the targeted pred is always in position 1


    vor_1=(in_cell2$voracity_tuned[1]-mean_vor_pred)/sd_vor_pred
  
    vor_z_1=(in_cell2$voracity_tuned[z+1]-mean_vor_prey)/sd_vor_prey
    
    size_z_1=(in_cell2$body_size[z+1]-mean_size_prey)/sd_size_prey
    
    size_1=(in_cell2$body_size[1]-mean_size_pred)/sd_size_pred
    
    size_x_size=(in_cell2$body_size[z+1]*in_cell2$body_size[1]-mean_size_x_size)/sd_size_x_size
    
    vor_x_vor=(in_cell2$voracity_tuned[z+1]*in_cell2$voracity_tuned[1]-mean_vor_x_vor)/sd_vor_x_vor


       if (mode=="sw"){
       in_cell2$p_encounter[z+1]=1/(1+exp(-1*(1+0.2*vor_1+0.05*vor_z_1+0.2*vor_x_vor+0.05*size_z_1+0.05*size_1+0.05*size_x_size)))
       }
       if (mode=="ah"){
       in_cell2$p_encounter[z+1]=1/(1+exp(-1*(1+0.1*vor_1+0.1*vor_z_1+0.1*vor_x_vor+0.1*size_z_1+0.1*size_1+0.1*size_x_size)))
       }


      if(in_cell2$p_encounter[z+1]<0) in_cell2$p_encounter[z+1]=0
      if(in_cell2$p_encounter[z+1]>1) in_cell2$p_encounter[z+1]=1


    a=in_cell2$p_encounter[z+1]
    b=runif(1,min=0,max=1)

    if (a>b){    ##if encounter occurs 

    if (in_cell2$pred_prey[z+1]=="prey"){
    in_cell2$encounters_pred[z+1]=in_cell2$encounters_pred[z+1]+1
    in_cell2$encounters_prey[1]=in_cell2$encounters_prey[1]+1
    }
    if (in_cell2$pred_prey[z+1]=="pred"){         ##we condiser that a IGP prey has been encountered by an IGP pred
    in_cell2$encounters_prey[1]=in_cell2$encounters_prey[1]+1
    in_cell2$encounters_pred[z+1]=in_cell2$encounters_pred[z+1]+1
    }

     vor_1=(in_cell2$voracity_tuned[1]-mean_vor_pred)/sd_vor_pred

     spd_ratio=((in_cell2$speed[1]/in_cell2$speed[z+1])-mean_spd_ratio)/sd_spd_ratio

     size_ratio=((in_cell2$body_size[1]/in_cell2$body_size[z+1])-mean_size_ratio)/sd_size_ratio
     
     
     #####for retaliation
     inv_spd_ratio=((in_cell2$speed[z+1]/in_cell2$speed[1])-mean_spd_ratio)/sd_spd_ratio
     inv_size_ratio=((in_cell2$body_size[z+1]/in_cell2$body_size[1])-mean_size_ratio)/sd_size_ratio

     if (mode=="sw"){
     in_cell2$p_predation[z+1]=(1/(1+exp(-1*(1+#+1*(spd_ratio)
                          0.3*vor_1+
                          0.001*(size_ratio)))))
     }
     if (mode=="ah"){
     in_cell2$p_predation[z+1]=(1/(1+exp(-1*(1+0.1*(spd_ratio)+
                          0.1*vor_1+
                          0.1*(size_ratio)))))
     }


        if(in_cell2$p_predation[z+1]<0) in_cell2$p_predation[z+1]=0
        if(in_cell2$p_predation[z+1]>1) in_cell2$p_predation[z+1]=1


    a=in_cell2$p_predation[z+1]
    b=runif(1,min=control_attack_rate,max=1)
    
    print("p_predation from predator move")
    print(a)
    

    if (a>b){    ##if predation occurs
    in_cell2$alive[z+1]=3    ##death from predation
    in_cell2$date_death[z+1]=i  ##date of death
    in_cell2$eating[1]=1
    in_cell2$food_mass[1]<-in_cell2$body_size[z+1]+in_cell2$energy_tank[z+1]

    }
    
    
    #####ADDING RETALIATION
    if (a<=b & in_cell2$pred_prey[z+1]=="pred"){ ##if predation does not occur, and prey is predator, there is chance of retaliation
        
        if(mode=="sw" | mode=="ah"){  ###retaliation is always done as if they were active hunters as no device (web, location) has been built!!!!!
        p=(1/(1+exp(-1*(1+0.1*(inv_spd_ratio)+     ###parameters as in active hunting, speed matters, notice the 1/spd and 1/size ratios
                          0.1*((in_cell2$voracity_tuned[z+1]-mean_vor_pred)/sd_vor_pred)+
                          0.1*(inv_size_ratio)))))
        }

    
    if (p>runif(1,min=control_attack_rate,max=1)){    ##if predation occurs
    in_cell2$alive[1]=3    ##death from predation
    in_cell2$date_death[1]=i  ##date of death
    in_cell2$eating[z+1]=1
    in_cell2$food_mass[z+1]<-in_cell2$body_size[1]+in_cell2$energy_tank[1]
    print("PREDATION FROM RETALIATION..................................................................................")

    }
    }
    
    
    
    }
   if(in_cell2$alive[z+1]==3){
   z=n_preys_in_cell+1
   }else{
  z=z+1}
  }
  }

  return(in_cell2)
}

  ##below, we set a background mortality for predators, as they do not have any predators nor parasites themselves
  ## mortality depends on voracity, search area (positively) and negatively on speed and body size


pred_background<-function(pred,i,t)
  {
  if (pred$alive[t]==1){
   
  voracity<-(pred$voracity_tuned[t]-mean_vor_pred)/sd_vor_pred
  
  search_area<-(pred$search_area_tuned[t]-mean_search_area_pred)/sd_search_area_pred  ##
  
  speed<-(pred$speed[t]-mean_spd_pred)/sd_spd_pred
  
  body_size<-(pred$body_size[t]-mean_size_pred)/sd_size_pred

  if (mode=="sw"){
  p_death<-tunea_background*(1/(1+exp(-1*(1+0.2*voracity+0.2*search_area-2*speed-2*body_size))))    #tunea_background   tunea_background*
  }

  if (mode=="ah"){
  p_death<-tunea_background*(1/(1+exp(-1*(1+1*voracity+1*search_area-1*speed-1*body_size))))    #tunea_background   tunea_background*
  }

  critico=runif(1)

  if (p_death>critico){
  pred$alive[t]=5   ###the predator dies from background mortality
  pred$date_death[t]=i

  }
  }
  return(pred)
}



repro<-function(TEMP,day,x,x_w_genes,mod_type1,mod_type2,mod_type3,mod_type4,rho)
{
x<-x[do.call(order,x[c("ID")]),]
x_w_genes<-x_w_genes[do.call(order,x_w_genes[c("ID")]),]


    todos<-data.frame(x_w_genes,x)  ####the same named traits get a .1, so these are the ones that came from the original population

#
    max_ID<-max(todos$ID) ##to know the next ID to assign to new offspring


    todos$budget<-todos$energy_tank.1  ###otherwise, the original energy tank is updated

    sub_rep<-subset(todos,alive==4)###set reproductive individuals to enter function
    no_rep<-subset(todos,alive!=4) ###set non-reproductive aside to merge later for output


    ###random order (so if odd removed, is not always the last ID)
    sub_rep$random<-runif(nrow(sub_rep))
    sub_rep<-sub_rep[do.call(order,sub_rep[c("random")]),]   ##shuffles the order in which each day each animal acts



    if(round((nrow(sub_rep)/2),0)!=nrow(sub_rep)/2){ #is odd - and one will not find a mate
    no_rep<-rbind(no_rep,sub_rep[nrow(sub_rep),])
    sub_rep<-sub_rep[1:(nrow(sub_rep)-1),]
    }


    ###estimating offspring number for the oviposition event
    sub_rep$min_surv=deadly_tank*sub_rep$body_size.1

    sub_rep$for_rep<-ifelse(sub_rep$pred_prey=="pred", sub_rep$budget-(sub_rep$min_surv)*keep_for_surv_pred,
     sub_rep$budget-(sub_rep$min_surv)*keep_for_surv_prey)

    sub_rep$off_num<-round(sub_rep$for_rep/((sub_rep$tank_ini*sub_rep$size_ini)+sub_rep$size_ini),0)
    sub_rep$fecundity<-sub_rep$fecundity+sub_rep$off_num
    sub_rep$rep_count<-sub_rep$rep_count+1
    sub_rep$energy_tank.1<-ifelse(sub_rep$pred_prey=="pred", sub_rep$min_surv*keep_for_surv_pred,
      sub_rep$min_surv*keep_for_surv_prey)

    tot_offs<-sum(sub_rep$off_num)    ##number of total offspring produced by the population that day

    sub_rep$alive<-ifelse(sub_rep$alive==4,1,sub_rep$alive)

    ####The number that made it odd (unmated) returns to normal and will be given an opportunity tomorrow
    #sub_rep$alive<-ifelse(sub_rep$ID==the_ID,4,sub_rep$alive)
    #sub_rep$rep_count<-ifelse(sub_rep$ID==the_ID,sub_rep$rep_count-1,sub_rep$rep_count)
    #


    sub_rep$alive<-ifelse(sub_rep$rep_count==max_rep_prey&sub_rep$pred_prey=="prey",6,sub_rep$alive)
    sub_rep$alive<-ifelse(sub_rep$rep_count==max_rep_pred&sub_rep$pred_prey=="pred",6,sub_rep$alive)
    sub_rep$date_death<-ifelse(sub_rep$date_death==0&sub_rep$alive==6,day,sub_rep$date_death)
    sub_rep$age_rep<-ifelse(sub_rep$rep_count==1,day,sub_rep$age_rep)

    ###below we collect the entire file as to have identical structure and var names

    gene_offs<-todos

    ###the following loop ensures that the array has enough space to accomodate all newborns
    while (nrow(gene_offs)<tot_offs){

    gene_offs<-rbind(gene_offs,todos)

    }

    gene_offs$new<-0    ##to distinguish new offspring updating the pseudofile so everything else can be erased

    gene_offs$g_numb_prt1<-0 ##generation number of one of the parents
    gene_offs$g_numb_prt2<-0 ##generation number of the other parent

    gene_offs$ID_prt1<-0 ##Id number of one of the parents
    gene_offs$ID_prt2<-0 ##Id number of the other parent


    pos_1<-c(2,7,12,18,23,28,34,39,44,50,55,60,65)


    ###making gametes with recombination and crossing mating pairs
    ##first 1 vs. 2
    i=1
    count_offs=1
    while (i<=nrow(sub_rep)){ ###each parent  nrow(sub_rep)
      for (j in 1:sub_rep$off_num[i]){ ###for each offspring

      gene_offs$ID[count_offs]=count_offs+max_ID
     
      gene_offs$new[count_offs]=1 ##is a new animal to enter the simulation
      ###below we prepare female gametes (for the eggs ready to be fertilized)

      for(trait in 1:13){
     
      ###trait=1
      zzz<-gametator(i,sub_rep,pos_1[trait])
      
      gene_offs[count_offs,pos_1[trait]][1:n_loci]<-zzz[,1]
      gene_offs[count_offs,pos_1[trait]+1][1:n_loci]<-zzz[,2]
      gene_offs[count_offs,pos_1[trait]+2][1:n_loci]<-zzz[,3]
      gene_offs[count_offs,pos_1[trait]+3][1:n_loci]<-zzz[,4]


      }
      
      
      
      ###below we call for male gametes (the mate is count_offs+1, the next position)
      cr=round(runif(1,min=1,max=2),0) ###which chromosome 1 or 2 in gamete

      for(trait in 1:13){
          

          ###trait=1
          zzz<-gametator(i+1,sub_rep,pos_1[trait])


          if (cr==1){
          gene_offs[count_offs,pos_1[trait]+2][1:n_loci]<-zzz[,3]
          gene_offs[count_offs,pos_1[trait]+3][1:n_loci]<-zzz[,4]
          }
          if (cr==2){
          gene_offs[count_offs,pos_1[trait]][1:n_loci]<-zzz[,1]
          gene_offs[count_offs,pos_1[trait]+1][1:n_loci]<-zzz[,2]
          }

      }

      

  
      gene_offs$ID_prt1[count_offs]<-sub_rep$ID[i]
      gene_offs$ID_prt2[count_offs]<-sub_rep$ID[i+1]
      gene_offs$g_numb_prt1[count_offs]<-sub_rep$g_numb_prt1[i]+1
      gene_offs$g_numb_prt2[count_offs]<-sub_rep$g_numb_prt2[i+1]+1

    count_offs=count_offs+1
    }##closes offspring for one parent pair
    i=i+2
    }



    
    ##now 2 vs. 1 - reciprocal hermafroditism
    
    i=2
    
    while (i<=nrow(sub_rep)){ ###each parent  nrow(sub_rep)
      for (j in 1:sub_rep$off_num[i]){ ###for each offspring

      gene_offs$ID[count_offs]=count_offs+max_ID
      
      gene_offs$new[count_offs]=1 ##is a new animal to enter the simulation
      ###below we prepare female gametes (for the eggs ready to be fertilized)


     for(trait in 1:13){
      
      ###trait=1
      zzz<-gametator(i,sub_rep,pos_1[trait])

      gene_offs[count_offs,pos_1[trait]][1:n_loci]<-zzz[,1]
      gene_offs[count_offs,pos_1[trait]+1][1:n_loci]<-zzz[,2]
      gene_offs[count_offs,pos_1[trait]+2][1:n_loci]<-zzz[,3]
      gene_offs[count_offs,pos_1[trait]+3][1:n_loci]<-zzz[,4]


      }



      ###below we call for male gametes (the mate is count_offs+1, the next position)
      cr=round(runif(1,min=1,max=2),0) ###which chromosome 1 or 2 in gamete

      for(trait in 1:13){
          ###trait=1
          zzz<-gametator(i-1,sub_rep,pos_1[trait])


          if (cr==1){
          gene_offs[count_offs,pos_1[trait]+2][1:n_loci]<-zzz[,3]
          gene_offs[count_offs,pos_1[trait]+3][1:n_loci]<-zzz[,4]
          }
          if (cr==2){
          gene_offs[count_offs,pos_1[trait]][1:n_loci]<-zzz[,1]
          gene_offs[count_offs,pos_1[trait]+1][1:n_loci]<-zzz[,2]
          }

      }


      

      gene_offs$ID_prt1[count_offs]<-sub_rep$ID[i]
      gene_offs$ID_prt2[count_offs]<-sub_rep$ID[i-1]
      gene_offs$g_numb_prt1[count_offs]<-sub_rep$g_numb_prt1[i]+1
      gene_offs$g_numb_prt2[count_offs]<-sub_rep$g_numb_prt2[i-1]+1


    count_offs=count_offs+1
    }##closes offspring for one parent pair
    i=i+2
    }




    ###############################
    ###gene effects in offspring###
    ###############################
    rho=1-rho ###to induce the desired effect.


    #removing the non-existing animals from the matrix (they were there to maitain the data structure)
    gene_offs<-subset(gene_offs,new==1)


    for (i in 1:nrow(gene_offs)){

    ###MOD1

#
    gene_offs$phtp1[i]<-sum(gene_offs[i,3][1:n_loci])+sum(gene_offs[i,5][1:n_loci])
#
    if(mod_type1=="neg"){

     gene_offs$phtp2[i]<-(sum(1-gene_offs[i,3][(round(rho*n_loci,0)+1):n_loci])+sum(1-gene_offs[i,5][(round(rho*n_loci,0)+1):n_loci])+
      sum(gene_offs[i,8][1:round(rho*n_loci,0)])+sum(gene_offs[i,10][1:round(rho*n_loci,0)]))

      }

    if(mod_type1=="pos"){
    gene_offs$phtp2[i]<-(sum(gene_offs[i,3][(round(rho*n_loci,0)+1):n_loci])+sum(gene_offs[i,5][(round(rho*n_loci,0)+1):n_loci])+
      sum(gene_offs[i,8][1:round(rho*n_loci,0)])+sum(gene_offs[i,10][1:round(rho*n_loci,0)]))
      }


    if(mod_type1=="neg"){
    gene_offs$phtp3[i]<-(sum(1-gene_offs[i,3][(round(rho*n_loci,0)+1):n_loci])+sum(1-gene_offs[i,5][(round(rho*n_loci,0)+1):n_loci])+
      sum(gene_offs[i,13][1:round(rho*n_loci,0)])+sum(gene_offs[i,15][1:round(rho*n_loci,0)]))
    }

    if(mod_type1=="pos"){
    gene_offs$phtp3[i]<-(sum(gene_offs[i,3][(round(rho*n_loci,0)+1):n_loci])+sum(gene_offs[i,5][(round(rho*n_loci,0)+1):n_loci])+
      sum(gene_offs[i,13][1:round(rho*n_loci,0)])+sum(gene_offs[i,15][1:round(rho*n_loci,0)]))
    }

    ###MOD2
    gene_offs$phtp4[i]<-sum(gene_offs[i,19][1:n_loci])+sum(gene_offs[i,21][1:n_loci])

    if(mod_type2=="neg"){
     gene_offs$phtp5[i]<-(sum(1-gene_offs[i,19][(round(rho*n_loci,0)+1):n_loci])+sum(1-gene_offs[i,21][(round(rho*n_loci,0)+1):n_loci])+
      sum(gene_offs[i,24][1:round(rho*n_loci,0)])+sum(gene_offs[i,26][1:round(rho*n_loci,0)]))
    }

    if(mod_type2=="pos"){
#
    gene_offs$phtp5[i]<-(sum(gene_offs[i,19][(round(rho*n_loci,0)+1):n_loci])+sum(gene_offs[i,21][(round(rho*n_loci,0)+1):n_loci])+
      sum(gene_offs[i,24][1:round(rho*n_loci,0)])+sum(gene_offs[i,26][1:round(rho*n_loci,0)]))

   }
    if(mod_type2=="neg"){
    gene_offs$phtp6[i]<-(sum(1-gene_offs[i,19][(round(rho*n_loci,0)+1):n_loci])+sum(1-gene_offs[i,21][(round(rho*n_loci,0)+1):n_loci])+
        sum(gene_offs[i,29][1:round(rho*n_loci,0)])+sum(gene_offs[i,31][1:round(rho*n_loci,0)]))
    }
    if(mod_type2=="pos"){
    gene_offs$phtp6[i]<-(sum(gene_offs[i,19][(round(rho*n_loci,0)+1):n_loci])+sum(gene_offs[i,21][(round(rho*n_loci,0)+1):n_loci])+
        sum(gene_offs[i,29][1:round(rho*n_loci,0)])+sum(gene_offs[i,31][1:round(rho*n_loci,0)]))
    }

    ###MOD3
    gene_offs$phtp7[i]<-sum(gene_offs[i,35][1:n_loci])+sum(gene_offs[i,37][1:n_loci])

    if(mod_type3=="neg"){
    gene_offs$phtp8[i]<-(sum(1-gene_offs[i,35][(round(rho*n_loci,0)+1):n_loci])+sum(1-gene_offs[i,37][(round(rho*n_loci,0)+1):n_loci])+
      sum(gene_offs[i,40][1:round(rho*n_loci,0)])+sum(gene_offs[i,42][1:round(rho*n_loci,0)]))
    }
    if(mod_type3=="pos"){
    gene_offs$phtp8[i]<-(sum(gene_offs[i,35][(round(rho*n_loci,0)+1):n_loci])+sum(gene_offs[i,37][(round(rho*n_loci,0)+1):n_loci])+
      sum(gene_offs[i,40][1:round(rho*n_loci,0)])+sum(gene_offs[i,42][1:round(rho*n_loci,0)]))
    }
    if(mod_type3=="neg"){
    gene_offs$phtp9[i]<-(sum(1-gene_offs[i,35][(round(rho*n_loci,0)+1):n_loci])+sum(1-gene_offs[i,37][(round(rho*n_loci,0)+1):n_loci])+
      sum(gene_offs[i,45][1:round(rho*n_loci,0)])+sum(gene_offs[i,47][1:round(rho*n_loci,0)]))
    }
    if(mod_type3=="pos"){
    gene_offs$phtp9[i]<-(sum(gene_offs[i,35][(round(rho*n_loci,0)+1):n_loci])+sum(gene_offs[i,37][(round(rho*n_loci,0)+1):n_loci])+
      sum(gene_offs[i,45][1:round(rho*n_loci,0)])+sum(gene_offs[i,47][1:round(rho*n_loci,0)]))
    }

    ###MOD4
    gene_offs$phtp10[i]<-sum(gene_offs[i,51][1:n_loci])+sum(gene_offs[i,53][1:n_loci])

    if(mod_type4=="neg"){
    gene_offs$phtp11[i]<-(sum(1-gene_offs[i,51][(round(rho*n_loci,0)+1):n_loci])+sum(1-gene_offs[i,53][(round(rho*n_loci,0)+1):n_loci])+
      sum(gene_offs[i,56][1:round(rho*n_loci,0)])+sum(gene_offs[i,58][1:round(rho*n_loci,0)]))
    }
    if(mod_type4=="pos"){
    gene_offs$phtp11[i]<-(sum(gene_offs[i,51][(round(rho*n_loci,0)+1):n_loci])+sum(gene_offs[i,53][(round(rho*n_loci,0)+1):n_loci])+
      sum(gene_offs[i,56][1:round(rho*n_loci,0)])+sum(gene_offs[i,58][1:round(rho*n_loci,0)]))
    }
    if(mod_type4=="neg"){
    gene_offs$phtp12[i]<-(sum(1-gene_offs[i,51][(round(rho*n_loci,0)+1):n_loci])+sum(1-gene_offs[i,53][(round(rho*n_loci,0)+1):n_loci])+
      sum(gene_offs[i,61][1:round(rho*n_loci,0)])+sum(gene_offs[i,63][1:round(rho*n_loci,0)]))
    }
    if(mod_type4=="pos"){
    gene_offs$phtp12[i]<-(sum(gene_offs[i,51][(round(rho*n_loci,0)+1):n_loci])+sum(gene_offs[i,53][(round(rho*n_loci,0)+1):n_loci])+
      sum(gene_offs[i,61][1:round(rho*n_loci,0)])+sum(gene_offs[i,63][1:round(rho*n_loci,0)]))
    }

    ###actE_met
    gene_offs$phtp13[i]<-sum(gene_offs[i,66][1:n_loci])+sum(gene_offs[i,68][1:n_loci])
    }


    ###assigning the values to the real trait names
    gene_offs[,names(gene_offs)==trait_vals[mod1_1,1]]<-gene_offs$phtp1
    gene_offs[,names(gene_offs)==trait_vals[mod1_2,1]]<-gene_offs$phtp2
    gene_offs[,names(gene_offs)==trait_vals[mod1_3,1]]<-gene_offs$phtp3
    gene_offs[,names(gene_offs)==trait_vals[mod2_1,1]]<-gene_offs$phtp4
    gene_offs[,names(gene_offs)==trait_vals[mod2_2,1]]<-gene_offs$phtp5
    gene_offs[,names(gene_offs)==trait_vals[mod2_3,1]]<-gene_offs$phtp6
    gene_offs[,names(gene_offs)==trait_vals[mod3_1,1]]<-gene_offs$phtp7
    gene_offs[,names(gene_offs)==trait_vals[mod3_2,1]]<-gene_offs$phtp8
    gene_offs[,names(gene_offs)==trait_vals[mod3_3,1]]<-gene_offs$phtp9
    gene_offs[,names(gene_offs)==trait_vals[mod4_1,1]]<-gene_offs$phtp10
    gene_offs[,names(gene_offs)==trait_vals[mod4_2,1]]<-gene_offs$phtp11
    gene_offs[,names(gene_offs)==trait_vals[mod4_3,1]]<-gene_offs$phtp12
    gene_offs[,names(gene_offs)=="actE_met"]<-gene_offs$phtp13


    ###interpolating to assign real phenotypic values to the genes###
    #################################################################
    #################################################################
    if (gene_offs$pred_prey[1]=="prey"){
    for (i in 1:13){
    min_int<-trait_vals[i,6]
    max_int<-trait_vals[i,7]
    min_t1<-trait_vals[i,2]
    max_t1<-trait_vals[i,3]
    low_limit<-trait_limits[i,2]
    upp_limit<-trait_limits[i,3]

    gene_offs[,names(gene_offs)==trait_vals$trait[i]]<-interpol2(gene_offs
    [,names(gene_offs)==trait_vals$trait[i]],min_int,max_int,min_t1,max_t1)

    ###the following is to restrict the values to something "plausible" and to avoid negative traits
    gene_offs[,names(gene_offs)==trait_limits$trait[i]]<-ifelse(gene_offs[,names(gene_offs)==
      trait_limits$trait[i]]<low_limit,low_limit,gene_offs[,names(gene_offs)==trait_limits$trait[i]])

    gene_offs[,names(gene_offs)==trait_limits$trait[i]]<-ifelse(gene_offs[,names(gene_offs)==
      trait_limits$trait[i]]>upp_limit,upp_limit,gene_offs[,names(gene_offs)==trait_limits$trait[i]])


    #print(cbind(names(gene_offs)[names(gene_offs)==trait_vals$trait[i]],gene_offs[,names(gene_offs)==trait_vals$trait[i]]))
    }
    }

    if (gene_offs$pred_prey[1]=="pred"){
    for (i in 1:13){
    min_int<-trait_vals[i,8]
    max_int<-trait_vals[i,9]
    min_t1<-trait_vals[i,4]
    max_t1<-trait_vals[i,5]
    low_limit<-trait_limits[i,2]
    upp_limit<-trait_limits[i,3]

    gene_offs[,names(gene_offs)==trait_vals$trait[i]]<-interpol2(gene_offs
    [,names(gene_offs)==trait_vals$trait[i]],min_int,max_int,min_t1,max_t1)

    ###the following is to restrict the values to something "plausible" and to avoid negative traits
    gene_offs[,names(gene_offs)==trait_limits$trait[i]]<-ifelse(gene_offs[,names(gene_offs)==
      trait_limits$trait[i]]<low_limit,low_limit,gene_offs[,names(gene_offs)==trait_limits$trait[i]])

    gene_offs[,names(gene_offs)==trait_limits$trait[i]]<-ifelse(gene_offs[,names(gene_offs)==
      trait_limits$trait[i]]>upp_limit,upp_limit,gene_offs[,names(gene_offs)==trait_limits$trait[i]])


    }
    }

    if(gene_offs$pred_prey[1]=="pred"){
    gene_offs$eating<-as.integer(0)
    gene_offs$food_mass<-0.0 ##food ingested by predator at each step - this is then passed upon a feeding function for assessing assimmilation
    gene_offs$days_digest<-as.integer(0) ##this counts for how long this predator will be digesting the current item according to voracity.

    for (i in 1:nrow(gene_offs)){  ###offspring are born in the same coordinate as in which the mom laid the eggs
    gene_offs$coord_pred[i]<-sub_rep$coord_pred[sub_rep$ID==gene_offs$ID_prt1[i]]   ##the initial positions - seeds are always the same for simplicity
    }

    }


    if(gene_offs$pred_prey[1]=="prey"){
    for (i in 1:nrow(gene_offs)){
    gene_offs$coord_prey[i]<-sub_rep$coord_prey[sub_rep$ID==gene_offs$ID_prt1[i]]
    }
    }

    gene_offs$pheno<-as.integer(round(gene_offs$pheno,0))

    pasos<-c(nrow(gene_offs))  ##the number of cells actually walked on in one step - depends upon "search_area_tuned" and on what happens (finding food, a predator, etc.)
    pasos[1:nrow(gene_offs)]<-0
    gene_offs$pasos<-as.integer(pasos)

    gene_offs$eaten<-as.data.frame(matrix(nrow=nrow(gene_offs),ncol=1))     ##the amount of food eaten each day (step)
    gene_offs$eaten<-0

    gene_offs$alive<-as.integer(0)    ##0 means the animal has not been born, 1 - is active, 2 - dead from starvation, 3 - predated, 4 - became adult, reproduced and died

    gene_offs$encounters_prey<-as.integer(0)  ###to measure the actual number of encounters with predators each day (or gene_offs if in predators)

    gene_offs$encounters_pred<-as.integer(0)  ###to measure the actual number of encounters with predators each day (or gene_offs if in predators)

    gene_offs$global_prey_encs<-as.integer(0)
    gene_offs$global_pred_encs<-as.integer(0)

    gene_offs$instar<-as.integer(1)    ###to keeptrack the number of molts the animal has undergone

    gene_offs$random<-runif(nrow(gene_offs))

    gene_offs<-gene_offs[do.call(order,gene_offs[c("ID")]),]

    gene_offs$ID<-as.integer(gene_offs$ID)
        print(max_ID)
        print(gene_offs$ID)

    gene_offs$date_death<-as.integer(0)

    gene_offs$size_ini<-gene_offs$body_size      ###to keeptrack the initial size
    gene_offs$tank_ini<-gene_offs$energy_tank    ###as energy_tank here is merely the coefficient
    gene_offs$speed_ini<-gene_offs$speed
    gene_offs$assim_ini<-gene_offs$assim
    gene_offs$energy_tank<-gene_offs$body_size*gene_offs$tank_ini   ###tank_ini is the coefficient (proportion of tank_ini) and energy_tank is a proportion of body size here.
    coeff_speed<-interpol2(gene_offs$speed_ini,0.05,0.35,1,7)
    gene_offs$speed<-coeff_speed*(gene_offs$body_size+gene_offs$energy_tank)^gene_offs$speed_ini

    gene_offs$critical<-gene_offs$energy_tank/gene_offs$body_size    ##this ratio measures the amount of energy stored relative to the body size, necessary to estimate starvation and or moulting


    gene_offs$voracity_tuned<-gene_offs$voracity#0.1*(gene_offs$size_ini+gene_offs$tank_ini)^gene_offs$voracity
    gene_offs$search_area_tuned<-gene_offs$search_area#(gene_offs$size_ini+gene_offs$tank_ini)^gene_offs$search_area

    gene_offs$rep_count=0  ##number of reproductive events (number of clutches)

    gene_offs$fecundity=0  ##total number of offspring

    gene_offs$age_rep=0  ##age at first reproduction

    gene_offs$pheno<-as.integer(round(gene_offs$pheno*interpol2(TEMP,min_T,max_T,1,Q10pheno),0))

    gene_offs$pheno<-day+gene_offs$pheno ###to finally assign the date of birth

    gene_offs$energy_tank.1<-gene_offs$energy_tank
    gene_offs$voracity.1<-gene_offs$voracity
    gene_offs$speed.1<-gene_offs$speed
    gene_offs$body_size.1<-gene_offs$body_size
    gene_offs$met_rate.1<-gene_offs$met_rate
    gene_offs$growth.1<-gene_offs$growth
    gene_offs$search_area.1<-gene_offs$search_area
    gene_offs$assim.1<-gene_offs$assim
    gene_offs$pheno.1<-gene_offs$pheno
    gene_offs$vorQ10.1<-gene_offs$vorQ10
    gene_offs$spdQ10.1<-gene_offs$spdQ10
    gene_offs$srchQ10.1<-gene_offs$srchQ10
    gene_offs$actE_met.1<-gene_offs$actE_met

    gene_offs$new<-0 ###otherwise it will get in again at next looping

    if(sub_rep$pred_prey[1]=="prey"){
    genes_output<-rbind(sub_rep[,1:109],no_rep[,1:109],gene_offs[,1:109])
        genes_output<-genes_output[do.call(order,genes_output[c("ID")]),] ##sets the original ordering to the array
#
    genes_output[,70]<-genes_output$ID
    }

    if(sub_rep$pred_prey[1]=="pred"){
    genes_output<-rbind(sub_rep[,1:112],no_rep[,1:112],gene_offs[,1:112])
        genes_output<-genes_output[do.call(order,genes_output[c("ID")]),] ##sets the original ordering to the array
#
    genes_output[,70]<-genes_output$ID
    }



return(genes_output)
}


gametator<-function(i,sub_rep,pos_1)
 {
 #print(i)
  chiasma<-round(runif(1,min=1,max=n_loci),0)

  while (chiasma==n_loci){    ##chiasma at n_loci does not work so we remove it!!!
  chiasma<-round(runif(1,min=1,max=n_loci),0)
  }

  ID_1_1<-sub_rep[i,pos_1][1:chiasma]  ###i=animal, 2=ID_trait1, chiasma=position to break
  val_1_1<-sub_rep[i,pos_1+1][1:chiasma]
  ID_1_2<-sub_rep[i,pos_1][(chiasma+1):n_loci]
  val_1_2<-sub_rep[i,pos_1+1][(chiasma+1):n_loci]

  ID_2_1<-sub_rep[i,pos_1+2][1:chiasma]  ###i=animal, 2=ID_trait1, chiasma=position to break
  val_2_1<-sub_rep[i,pos_1+3][1:chiasma]
  ID_2_2<-sub_rep[i,pos_1+2][(chiasma+1):n_loci]
  val_2_2<-sub_rep[i,pos_1+3][(chiasma+1):n_loci]

  ID_1<-c(ID_1_1,ID_2_2)
  val_1<-c(val_1_1,val_2_2)
  ID_2<-c(ID_2_1,ID_1_2)
  val_2<-c(val_2_1,val_1_2)

return(data.frame(ID_1,val_1,ID_2,val_2))
}


  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ################# LOW T WITH PREDATORS ####################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################


      ################# MAIN FUNCTION##################################

  for (i in 1:steps){  #steps   1 step equals 1 day                  
  
  fungi<-fungi_func(cells,fungi,i)
    total_biomass<-sum(fungi$biomass[,i])
    total_biomass_out<-sum(fungi$biomass_out[,i])
    TC$BIOMASS[i]<-total_biomass
    TC$BIOMASS_OUT[i]<-total_biomass_out
    TC$PREY_EGGS[i]<-sum(prey$alive==0)
    TC$PREY_ALIVE[i]<-sum(prey$alive==1)
    TC$PREY_STARVED[i]<-sum(prey$alive==2)
    TC$PREY_PREDATED[i]<-sum(prey$alive==3)
    TC$PREY_SENESCED[i]<-sum(prey$alive==6)
    if (predators==1){
    TC$PREY_BMSS_OUT[i]<-sum(pred$food_mass)
    TC$PRED_EGGS[i]<-sum(pred$alive==0)
    TC$PRED_ALIVE[i]<-sum(pred$alive==1)
    TC$PRED_STARVED[i]<-sum(pred$alive==2)
    TC$PRED_PREDATED[i]<-sum(pred$alive==3)
    TC$PRED_SENESCED[i]<-sum(pred$alive==6)
    }


     print("LOW TEMPERATURE IN C - WITH PREDATORS")
     print(T)
     print("day")
     print(i)
     if (sum(fungi$biomass[,i])==0) stop("fungi_went_extint")

     prey$random<-runif(nrow(prey))
     prey<-prey[do.call(order,prey[c("random")]),]   ##shuffles the order in which each day each animal acts

     if (predators==1){
     pred$random<-runif(nrow(pred))
     pred<-pred[do.call(order,pred[c("random")]),]   ##shuffles the order in which each day each animal acts
     }

     prey<-tune_traits(prey,upper_tank_prey)
     prey<-tune_traits2(prey)

     prey$eaten<-0
     prey$encounters_pred<-0



     if (predators==1){
     pred<-tune_traits(pred,upper_tank_pred)
     pred<-tune_traits2(pred) #this will make only sense when predators feed on each other!!!!!!!!!!!
     pred$eating<-0
     pred$food_mass<-0
     pred$encounters_pred<-0
     pred$encounters_prey<-0
     pred$days_digest<-ifelse(pred$days_digest>0,pred$days_digest-1,0)
     }

     sum_prey_alive<-ifelse(prey$alive==1,1,0)
      if(i>9&sum(sum_prey_alive)==0) {
      write.table(prey,"prey_at_extintion.txt")  ##this is to estimate when prey are all killed (some may have reached adulthood and reproduced, though)
      write.table(i,"i_at_prey_extinction.txt")
      }      ##10 is max phenology for prey


     if (i>1)  ###controls when prey start mattering in the food web - here, one day after simulations start, so fungi have time to grow before depletion
     for (r in 1:nrow(prey)){

      if ((i>=prey$pheno[r])&&(prey$alive[r]==0)) {   ##when pheno (phenology) is reached, the day to be born has arrived and the animal activates
          prey$alive[r]=1
          }


      if (prey$alive[r]==1){

      if (predators==1){
      prey$pasos[r]<-0

      if (prey$search_area_tuned[r]>0){
      for (k in 1:prey$search_area_tuned[r]){ ###search_area_tuned - maximum number of steps to walk in one day (tick)

      if (prey$alive[r]==1){
      prey<-prey_mov(prey,pred,fungi,i,World_size,r)


      in_cell<-for_interaction(pred,prey,fungi,i,r)



      if (is.logical(in_cell)==F){


      in_cell<-predation_prey_move(in_cell,i)

      if(nrow(in_cell)>1){
      prey$alive[r]=in_cell$alive[1]
      prey$date_death[r]=in_cell$date_death[1]
      prey$encounters_pred[r]=prey$encounters_pred[r]+in_cell$encounters_pred[1]
      
      prey$global_pred_encs[r]=prey$global_pred_encs[r]+in_cell$encounters_pred[1]
      
      in_cell<-in_cell[2:nrow(in_cell),] ##Removes the prey from the first row



      for (dd in 1:nrow(in_cell)){
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell$ID[dd]){
      pred$encounters_prey[xx]<-pred$encounters_prey[xx]+in_cell$encounters_prey[dd]
      pred$global_prey_encs[xx]= pred$global_prey_encs[xx]+in_cell$encounters_prey[dd]
      pred$eating[xx]<-in_cell$eating[dd]
      pred$food_mass[xx]<-in_cell$food_mass[dd]
      }
      }
      }
      }
      }
      }

      }###end of moving for prey r in a World with predators

      }


      }else{
      prey$pasos[r]<-0

      if (prey$search_area_tuned[r]>0){
      for (k in 1:prey$search_area_tuned[r]){
      prey<-prey_mov(prey,fungi,i,World_size,r)

      }
 
      }
      }

      prey<-feed_prey(prey,i,fungi,par_food,eficiencia,upper_tank_prey,r)
      fungi<-fungi_eaten(prey,i,fungi,r,min_fungi,zero_fungi)




    prey<-metab_with_growth(prey,i,assigned,r,deadly_tank,upper_tank_prey)
      }
    }

      if (i>2)##controls when predators start mattering and moving in the food web
      if (predators==1){
      for (t in 1:nrow(pred)){
      if ((i>=pred$pheno[t])&&(pred$alive[t]==0)) {
          pred$alive[t]=1
          }

          if (pred$alive[t]==1&pred$days_digest[t]==0){
          pred<-pred_background(pred,i,t)
          if (pred$alive[t]==5) print(cbind("this one dies from background mortality",t))
          }

           sum_pred_alive<-ifelse(pred$alive==1,1,0)
          if (i>14&sum(sum_pred_alive)==0) stop("predators_went_extint") ##15 is max phenology for predator

      pred$pasos[t]<-0

          if (pred$search_area_tuned[t]>0&pred$alive[t]==1&pred$eating[t]==0&pred$days_digest[t]==0){          ###now, the predators that have not eaten yet, from prey moves, go out to hunt prey
          for (k in 1:pred$search_area_tuned[t]){
          
           if ((pred$days_digest[t]==0)&(pred$alive[t]==1)&(pred$eating[t]==0)){
 
          pred<-pred_mov(prey,pred,fungi,i,World_size,t)
          
          
#

      in_cell_x1<-as.data.frame(for_interaction_x1(pred,fungi,t))

#
      if (is.logical(in_cell_x1)==F){

      in_cell_x1<-predation_prey_move(in_cell_x1,i)   ##this function is identical as the predator acts as prey passes in_cell_x1 but gets in_cell as in_cell_x1!!!!!

      if(nrow(in_cell_x1)>1){                       ###updates the target predator
      pred$alive[t]=in_cell_x1$alive[1]
      pred$date_death[t]=in_cell_x1$date_death[1]
      pred$encounters_pred[t]=pred$encounters_pred[t]+in_cell_x1$encounters_pred[1]
      pred$global_pred_encs[t]= pred$global_pred_encs[t]+in_cell_x1$encounters_pred[1]

      in_cell_x1<-in_cell_x1[2:nrow(in_cell_x1),] ##Removes the pred[t] from the first row


      for (dd in 1:nrow(in_cell_x1)){     ##updates predators as they may have encounter the predator acting as prey, feed upon it, etc.!!!!!!
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell_x1$ID[dd]){
      pred$encounters_prey[xx]<-pred$encounters_prey[xx]+in_cell_x1$encounters_prey[dd]
      pred$global_prey_encs[xx]= pred$global_prey_encs[xx]+in_cell_x1$encounters_prey[dd]
      pred$eating[xx]<-in_cell_x1$eating[dd]
      pred$food_mass[xx]<-in_cell_x1$food_mass[dd]
      }
      }
      }
      }
      }

      ##the following only happens if the predator is alive and we are going to update the predator status if killed while moving!!!!
      #

      if (pred$alive[t]==1){
      in_cell2<-as.data.frame(for_interaction2_x1(pred,prey,fungi,t))

      if (is.logical(in_cell2)==F){
      in_cell2<-predation_pred_move(in_cell2,i)
      
     


      if(nrow(in_cell2)>1){

      pred$encounters_prey[t]=pred$encounters_prey[t]+in_cell2$encounters_prey[1]
      pred$global_prey_encs[t]=pred$global_prey_encs[t]+pred$encounters_prey[1]
      pred$eating[t]<-in_cell2$eating[1]
      pred$food_mass[t]<-in_cell2$food_mass[1]
  
      #####NEW FOR SPIDERS - UPDATE PREDATORS FROM RETALIATION / SEE ALSO BELOW
      pred$alive[t]=in_cell2$alive[1]
      pred$date_death[t]=in_cell2$date_death[1]
  
      in_cell2<-in_cell2[2:nrow(in_cell2),] ##Removes the pred from the first row
 
      for (dd in 1:nrow(in_cell2)){         ###updates prey
      for (xx in 1:nrow(prey)){
      if(prey$ID[xx]==in_cell2$ID[dd]&!is.na(charmatch(prey$pred_prey[xx],in_cell2$pred_prey[dd]))&in_cell2$pred_prey[dd]=="prey"){  ###modified on 18_02_2012
      prey$encounters_pred[xx]<-prey$encounters_pred[xx]+in_cell2$encounters_pred[dd]
      prey$global_pred_encs[xx]<-prey$global_pred_encs[xx]+in_cell2$encounters_pred[dd]

#
      prey$alive[xx]=in_cell2$alive[dd]
      prey$date_death[xx]=in_cell2$date_death[dd]
      }
      }
      }

      ##soso_start##     ###predators that have potentially acted as prey should be updated for encounters and for status
      for (dd in 1:nrow(in_cell2)){   ###updates predators as if they were prey
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell2$ID[dd]&!is.na(charmatch(pred$pred_prey[xx],in_cell2$pred_prey[dd]))&in_cell2$pred_prey[dd]=="pred"){  ###modified on 18_02_2012
      pred$encounters_pred[xx]<-pred$encounters_pred[xx]+in_cell2$encounters_pred[dd]
      pred$global_pred_encs[xx]<-pred$global_pred_encs[xx]+in_cell2$encounters_pred[dd]
      pred$alive[xx]=in_cell2$alive[dd]
      pred$date_death[xx]=in_cell2$date_death[dd]
      
      ######AND ALSO UPDATE PREY AS IF THEY ARE PREDATORS WHEN RETALIATION OCCURS - INCLUDING ASSIMILATION FROM FEEDING!!!!
      pred$eating[xx]<-in_cell2$eating[dd]
      pred$food_mass[xx]<-in_cell2$food_mass[dd]
      pred<-pred_assim(pred,xx,upper_tank_pred)

      }
      }
      }
    


      }
      }
      }


          }

          }
          }


          if (pred$alive[t]==1&pred$eating[t]==1){
          pred<-pred_assim(pred,t,upper_tank_pred)
          }

          if (pred$alive[t]==1){   ##new in book chapter, even if it reproduces, it expends energy
          pred<-metab_with_growth(pred,i,assigned,t,deadly_tank,upper_tank_pred)
          }

          }
          }



     if(sum(prey$alive==4)>1){
     all_prey<-repro(TEMP=T,day=i,prey,prey_w_genes,mod_type1=prey_mod_int_1,mod_type2=prey_mod_int_2,
     mod_type3=prey_mod_int_3,mod_type4=prey_mod_int_4,rho=rho_prey)

     if (all_prey$pred_prey[1]=="prey"){
      prey_w_genes<-all_prey[,1:69]
      prey<-all_prey[,70:109]
      names(prey)[1:14]<-c("ID","energy_tank","voracity","speed","body_size","met_rate","growth"
      ,"search_area","assim","pheno","vorQ10","spdQ10","srchQ10","actE_met")
      }
      }



     if(predators==1)
     if(sum(pred$alive==4)>1){
     all_preds<-repro(TEMP=T,day=i,pred,pred_w_genes,mod_type1=pred_mod_int_1,mod_type2=pred_mod_int_2,
      mod_type3=pred_mod_int_3,mod_type4=pred_mod_int_4,rho=rho_pred)

     if (all_preds$pred_prey[1]=="pred"){
      pred_w_genes<-all_preds[,1:69]
      pred<-all_preds[,70:112]
      names(pred)[1:14]<-c("ID","energy_tank","voracity","speed","body_size","met_rate","growth"
      ,"search_area","assim","pheno","vorQ10","spdQ10","srchQ10","actE_met")
      }
      }



     prey<-prey[do.call(order,prey[c("ID")]),] ##sets the original ordering to the array
     if(predators==1)
     pred<-pred[do.call(order,pred[c("ID")]),] ##sets the original ordering to the array



    plot(fungi$cells,fungi$biomass[,i])
  }




  ####outputs
  fungi$output<-ifelse(fungi$biomass[,i]>0,1,0)
  fungi$output

  sum(fungi$output)
  sum(fungi$biomass[,i])
  sum(prey$alive==1)
  mean(prey$critical[prey$alive==1])
  sum(pred$alive==1)
  mean(pred$critical[pred$alive==1])


  pred$alive
  prey$alive
  pred$instar
  prey$instar


  write.table(TC,"low_T_TC_w_preds.txt")   #entrem dades sense substituci a un fitxer nou i amb noms de variables
  write.table(prey,"low_T_prey_w_preds.txt")   #entrem dades sense substituci a un fitxer nou i amb noms de variables
  write.table(pred,"low_T_pred.txt")   #entrem dades sense substituci a un fitxer nou i amb noms de variables
  write.table(fungi,"low_T_fungi_w_preds.txt")   #entrem
  write.table(all_prey,"low_T_prey_genetics_w_preds.txt")
  write.table(all_preds,"low_T_pred_genetics_w_preds.txt")




  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ################# MEDIUM T WITH PREDATORS ###############################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################

########################################################################
######################## TRAITS ########################################
########################################################################


  prey_integration=switches$for_desintegration
  pred_integration=switches$for_desintegration
  predators=switches$predators
  rho_prey_2=switches$rho_prey_2
  rho_pred_2=switches$rho_pred_2
  T=switches$T2

  ##T=20
  min_r=exp(25.98-(0.68*(1/(0.0000862*(T+273.15)))))/((min_fungi*1000)^(1/4))  ##ind/indxday | Fig. 4 in Savage et al. 2004 Am. Nat.
  max_r=exp(25.98-(0.68*(1/(0.0000862*(T+273.15)))))/((max_fungi*1000)^(1/4))  ###it is a lower r when mass is larger


    ####################################################################################################################
    ####################################################################################################################
    #### LIBRARIES, GLOBAL FUNCTIONS AND CONSTANTS ####


              ###this file should be set with the values we want for the simulation (see "read_me_switches.xls" for explanation)

    ####TROPHIC CASCADE COLLECTOR##############
    ###########################################
    TC<-as.data.frame(matrix(nrow=steps,ncol=13))       ##this just collects the information on how fungi biomass changes from day to day
    names(TC)[1:13]<-c("BIOMASS","BIOMASS_OUT","PREY_EGGS","PREY_ALIVE","PREY_STARVED","PREY_PREDATED",
    "PREY_SENESCED","PREY_BMSS_OUT","PRED_EGGS","PRED_ALIVE","PRED_STARVED","PRED_PREDATED","PRED_SENESCED")

    ################# THE WORLD - N, SPACE AND TIME ########################################################
    ########################################################################################################
    World_size=as.integer(switches$World_size)      ###NUMBER OF CELLS SET UNIDIMENSIONALLY

    cells<-1:World_size

    cells<-as.data.frame(cells)

    n_prey=switches$n_prey#500*3                                    ###NUMBER OF PREY
    n_pred=switches$n_pred#281*3  # as.integer(round(n_prey*(1/10),0))     ###NUMBER OF PREDATORS


  seeds<-read.table("seeds.txt",header=T)
  seed_prey=seeds$seed_prey
  seed_pred=seeds$seed_pred


    ####fungi growth array
    fungi<-cells

     ##TO INCLUDE AUTOCORRELATION
    increase<-as.matrix(c(1:round(World_size/2,0)))
    decrease<-as.matrix(c(round(World_size/2,0):1))
    fungi$x<-as.matrix(rbind(increase,decrease))

    fungi$r<-interpol(fungi$x,min_r,max_r)


    fungi$ini<-interpol(fungi$x,min_fungi,max_fungi)
    fungi$K<-interpol(fungi$x,min_K,max_K)     ###########################################################################
    sum(fungi$K)

          ############################# TO REMOVE AUTOCORRELATION AND THE SAME r and ini ACROSS THE WORLD_SIZE CELLS #############################################
          if (autocor==0){
          names(fungi)

          set.seed(seed_prey)
          fungi$aleat<-runif(nrow(fungi))

          names(fungi)

          #[1] "cells" "r"     "ini"   "K" "aleat"

          r_sorted <- fungi[do.call(order,fungi[c(5)]),]  #finally how to sort in R

          r_sorted$orden<-as.numeric(World_size:1)

          r_sorted

          names(r_sorted)
          #[1] "cells" "r"     "ini"   "aleat" "orden"


          new_matrix<-as.data.frame(matrix(nrow=nrow(fungi),ncol=4))


          new_matrix[,1]=r_sorted$orden
          new_matrix[,2]=r_sorted$r
          new_matrix[,3]=r_sorted$ini
          new_matrix[,4]=r_sorted$K


          names(new_matrix)<-c("cells","r","ini","K")

          new_matrix

          fungi<-new_matrix[do.call(order,new_matrix[c(1)]),]

          }

  plot(fungi$cells,fungi$K)

  fungi$cells<-as.integer(fungi$cells)
  fungi$biomass_in<-matrix(nrow=nrow(fungi),ncol=steps)
  fungi$biomass_out<-matrix(nrow=nrow(fungi),ncol=steps)
  fungi$biomass<-matrix(nrow=nrow(fungi),ncol=steps)

  fungi$excess<-matrix(nrow=nrow(fungi),ncol=1,0)


########################################################################
######################## TRAITS ########################################
########################################################################

  prey<-prey2
  prey_w_genes<-prey_w_genes2
  pred<-pred2
  pred_w_genes<-pred_w_genes2

  prey$pheno<-round(prey$pheno*interpol2(T,min_T,max_T,1,Q10pheno),0) ##to include Q10 in dev time
  pred$pheno<-round(pred$pheno*interpol2(T,min_T,max_T,1,Q10pheno),0)

    ##############################################################################################################################################
    ##############################################################################################################################################
    ##############################################################################################################################################
 

      ################# MAIN FUNCTION##################################

  for (i in 1:steps){ #steps   1 step equals 1 day

  fungi<-fungi_func(cells,fungi,i)
    total_biomass<-sum(fungi$biomass[,i])
    total_biomass_out<-sum(fungi$biomass_out[,i])
    TC$BIOMASS[i]<-total_biomass
    TC$BIOMASS_OUT[i]<-total_biomass_out
    TC$PREY_EGGS[i]<-sum(prey$alive==0)
    TC$PREY_ALIVE[i]<-sum(prey$alive==1)
    TC$PREY_STARVED[i]<-sum(prey$alive==2)
    TC$PREY_PREDATED[i]<-sum(prey$alive==3)
    TC$PREY_SENESCED[i]<-sum(prey$alive==6)
    if (predators==1){
    TC$PREY_BMSS_OUT[i]<-sum(pred$food_mass)
    TC$PRED_EGGS[i]<-sum(pred$alive==0)
    TC$PRED_ALIVE[i]<-sum(pred$alive==1)
    TC$PRED_STARVED[i]<-sum(pred$alive==2)
    TC$PRED_PREDATED[i]<-sum(pred$alive==3)
    TC$PRED_SENESCED[i]<-sum(pred$alive==6)
    }


 
     print("MID TEMPERATURE IN C - WITH PREDATORS")
     print(T)
     print("day")
     print(i)
     if (sum(fungi$biomass[,i])==0) stop("fungi_went_extint")

     prey$random<-runif(nrow(prey))
     prey<-prey[do.call(order,prey[c("random")]),]   ##shuffles the order in which each day each animal acts

     if (predators==1){
     pred$random<-runif(nrow(pred))
     pred<-pred[do.call(order,pred[c("random")]),]   ##shuffles the order in which each day each animal acts
     }

     prey<-tune_traits(prey,upper_tank_prey)
     prey<-tune_traits2(prey)

     prey$eaten<-0
     prey$encounters_pred<-0



     if (predators==1){
     pred<-tune_traits(pred,upper_tank_pred)
     pred<-tune_traits2(pred) #this will make only sense when predators feed on each other!!!!!!!!!!!
     pred$eating<-0
     pred$food_mass<-0
     pred$encounters_pred<-0
     pred$encounters_prey<-0
     pred$days_digest<-ifelse(pred$days_digest>0,pred$days_digest-1,0)
     }

     sum_prey_alive<-ifelse(prey$alive==1,1,0)
      if(i>9&sum(sum_prey_alive)==0) {
      write.table(prey,"prey_at_extintion.txt")  ##this is to estimate when prey are all killed (some may have reached adulthood and reproduced, though)
      write.table(i,"i_at_prey_extinction.txt")
      }      ##10 is max phenology for prey


     if (i>1)  ###controls when prey start mattering in the food web - here, one day after simulations start, so fungi have time to grow before depletion
     for (r in 1:nrow(prey)){

      if ((i>=prey$pheno[r])&&(prey$alive[r]==0)) {   ##when pheno (phenology) is reached, the day to be born has arrived and the animal activates
          prey$alive[r]=1
          }


      if (prey$alive[r]==1){

      if (predators==1){
      prey$pasos[r]<-0

      if (prey$search_area_tuned[r]>0){
      for (k in 1:prey$search_area_tuned[r]){ ###search_area_tuned - maximum number of steps to walk in one day (tick)

      if (prey$alive[r]==1){
      prey<-prey_mov(prey,pred,fungi,i,World_size,r)


      in_cell<-for_interaction(pred,prey,fungi,i,r)



      if (is.logical(in_cell)==F){


      in_cell<-predation_prey_move(in_cell,i)

      if(nrow(in_cell)>1){
      prey$alive[r]=in_cell$alive[1]
      prey$date_death[r]=in_cell$date_death[1]
      prey$encounters_pred[r]=prey$encounters_pred[r]+in_cell$encounters_pred[1]
      
      prey$global_pred_encs[r]=prey$global_pred_encs[r]+in_cell$encounters_pred[1]
      

      in_cell<-in_cell[2:nrow(in_cell),] ##Removes the prey from the first row



      for (dd in 1:nrow(in_cell)){
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell$ID[dd]){
      pred$encounters_prey[xx]<-pred$encounters_prey[xx]+in_cell$encounters_prey[dd]
      pred$global_prey_encs[xx]= pred$global_prey_encs[xx]+in_cell$encounters_prey[dd]
      pred$eating[xx]<-in_cell$eating[dd]
      pred$food_mass[xx]<-in_cell$food_mass[dd]
      }
      }
      }
      }
      }
      }
       }###end of moving for prey r in a World with predators
 
      }


      }else{
      prey$pasos[r]<-0

      if (prey$search_area_tuned[r]>0){
      for (k in 1:prey$search_area_tuned[r]){
      prey<-prey_mov(prey,fungi,i,World_size,r)

      }
 
      }
      }

      prey<-feed_prey(prey,i,fungi,par_food,eficiencia,upper_tank_prey,r)
      fungi<-fungi_eaten(prey,i,fungi,r,min_fungi,zero_fungi)




    prey<-metab_with_growth(prey,i,assigned,r,deadly_tank,upper_tank_prey)
      }
    }

      if (i>2)##controls when predators start mattering and moving in the food web
      if (predators==1){
      for (t in 1:nrow(pred)){
      if ((i>=pred$pheno[t])&&(pred$alive[t]==0)) {
          pred$alive[t]=1
          }

          if (pred$alive[t]==1&pred$days_digest[t]==0){
          pred<-pred_background(pred,i,t)
          if (pred$alive[t]==5) print(cbind("this one dies from background mortality",t))
          }

           sum_pred_alive<-ifelse(pred$alive==1,1,0)
          if (i>14&sum(sum_pred_alive)==0) stop("predators_went_extint") ##15 is max phenology for predator

      pred$pasos[t]<-0

          if (pred$search_area_tuned[t]>0&pred$alive[t]==1&pred$eating[t]==0&pred$days_digest[t]==0){          ###now, the predators that have not eaten yet, from prey moves, go out to hunt prey
          for (k in 1:pred$search_area_tuned[t]){
          
 
          if ((pred$days_digest[t]==0)&(pred$alive[t]==1)&(pred$eating[t]==0)){
#
          pred<-pred_mov(prey,pred,fungi,i,World_size,t)
          
          

      in_cell_x1<-as.data.frame(for_interaction_x1(pred,fungi,t))

#
      if (is.logical(in_cell_x1)==F){

      in_cell_x1<-predation_prey_move(in_cell_x1,i)   ##this function is identical as the predator acts as prey passes in_cell_x1 but gets in_cell as in_cell_x1!!!!!

 
      if(nrow(in_cell_x1)>1){                       ###updates the target predator
      pred$alive[t]=in_cell_x1$alive[1]
      pred$date_death[t]=in_cell_x1$date_death[1]
      pred$encounters_pred[t]=pred$encounters_pred[t]+in_cell_x1$encounters_pred[1]
      pred$global_pred_encs[t]= pred$global_pred_encs[t]+in_cell_x1$encounters_pred[1]

      in_cell_x1<-in_cell_x1[2:nrow(in_cell_x1),] ##Removes the pred[t] from the first row


      for (dd in 1:nrow(in_cell_x1)){     ##updates predators as they may have encounter the predator acting as prey, feed upon it, etc.!!!!!!
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell_x1$ID[dd]){
      pred$encounters_prey[xx]<-pred$encounters_prey[xx]+in_cell_x1$encounters_prey[dd]
      pred$global_prey_encs[xx]= pred$global_prey_encs[xx]+in_cell_x1$encounters_prey[dd]
      pred$eating[xx]<-in_cell_x1$eating[dd]
      pred$food_mass[xx]<-in_cell_x1$food_mass[dd]
      }
      }
      }
      }
      }

      ##the following only happens if the predator is alive and we are going to update the predator status if killed while moving!!!!
      #

      if (pred$alive[t]==1){
      in_cell2<-as.data.frame(for_interaction2_x1(pred,prey,fungi,t))
 
      if (is.logical(in_cell2)==F){
      in_cell2<-predation_pred_move(in_cell2,i)
      
     


      if(nrow(in_cell2)>1){

      pred$encounters_prey[t]=pred$encounters_prey[t]+in_cell2$encounters_prey[1]
      pred$global_prey_encs[t]=pred$global_prey_encs[t]+pred$encounters_prey[1]
      pred$eating[t]<-in_cell2$eating[1]
      pred$food_mass[t]<-in_cell2$food_mass[1]
  
      #####NEW FOR SPIDERS - UPDATE PREDATORS FROM RETALIATION / SEE ALSO BELOW
      pred$alive[t]=in_cell2$alive[1]
      pred$date_death[t]=in_cell2$date_death[1]
  
      in_cell2<-in_cell2[2:nrow(in_cell2),] ##Removes the pred from the first row

      for (dd in 1:nrow(in_cell2)){         ###updates prey
      for (xx in 1:nrow(prey)){
      if(prey$ID[xx]==in_cell2$ID[dd]&!is.na(charmatch(prey$pred_prey[xx],in_cell2$pred_prey[dd]))&in_cell2$pred_prey[dd]=="prey"){  ###modified on 18_02_2012
      prey$encounters_pred[xx]<-prey$encounters_pred[xx]+in_cell2$encounters_pred[dd]
      prey$global_pred_encs[xx]<-prey$global_pred_encs[xx]+in_cell2$encounters_pred[dd]

#
      prey$alive[xx]=in_cell2$alive[dd]
      prey$date_death[xx]=in_cell2$date_death[dd]
      }
      }
      }

       ###predators that have potentially acted as prey should be updated for encounters and for status
      for (dd in 1:nrow(in_cell2)){   ###updates predators as if they were prey
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell2$ID[dd]&!is.na(charmatch(pred$pred_prey[xx],in_cell2$pred_prey[dd]))&in_cell2$pred_prey[dd]=="pred"){  ###modified on 18_02_2012
      pred$encounters_pred[xx]<-pred$encounters_pred[xx]+in_cell2$encounters_pred[dd]
      pred$global_pred_encs[xx]<-pred$global_pred_encs[xx]+in_cell2$encounters_pred[dd]
      pred$alive[xx]=in_cell2$alive[dd]
      pred$date_death[xx]=in_cell2$date_death[dd]
      
      ######AND ALSO UPDATE PREY AS IF THEY ARE PREDATORS WHEN RETALIATION OCCURS - INCLUDING ASSIMILATION FROM FEEDING!!!!
      pred$eating[xx]<-in_cell2$eating[dd]
      pred$food_mass[xx]<-in_cell2$food_mass[dd]
      pred<-pred_assim(pred,xx,upper_tank_pred)

      }
      }
      }
   


      }
      }
      }


          }

          }
          }


          if (pred$alive[t]==1&pred$eating[t]==1){
          pred<-pred_assim(pred,t,upper_tank_pred)
          }

          if (pred$alive[t]==1){   ##new in book chapter, even if it reproduces, it expends energy
          pred<-metab_with_growth(pred,i,assigned,t,deadly_tank,upper_tank_pred)
          }

          }
          }



     if(sum(prey$alive==4)>1){
     all_prey<-repro(TEMP=T,day=i,prey,prey_w_genes,mod_type1=prey_mod_int_1,mod_type2=prey_mod_int_2,
     mod_type3=prey_mod_int_3,mod_type4=prey_mod_int_4,rho=rho_prey)

     if (all_prey$pred_prey[1]=="prey"){
      prey_w_genes<-all_prey[,1:69]
      prey<-all_prey[,70:109]
      names(prey)[1:14]<-c("ID","energy_tank","voracity","speed","body_size","met_rate","growth"
      ,"search_area","assim","pheno","vorQ10","spdQ10","srchQ10","actE_met")
      }
      }



     if(predators==1)
     if(sum(pred$alive==4)>1){
     all_preds<-repro(TEMP=T,day=i,pred,pred_w_genes,mod_type1=pred_mod_int_1,mod_type2=pred_mod_int_2,
      mod_type3=pred_mod_int_3,mod_type4=pred_mod_int_4,rho=rho_pred)

     if (all_preds$pred_prey[1]=="pred"){
      pred_w_genes<-all_preds[,1:69]
      pred<-all_preds[,70:112]
      names(pred)[1:14]<-c("ID","energy_tank","voracity","speed","body_size","met_rate","growth"
      ,"search_area","assim","pheno","vorQ10","spdQ10","srchQ10","actE_met")
      }
      }



     prey<-prey[do.call(order,prey[c("ID")]),] ##sets the original ordering to the array
     if(predators==1)
     pred<-pred[do.call(order,pred[c("ID")]),] ##sets the original ordering to the array



    plot(fungi$cells,fungi$biomass[,i])
  }





  ####outputs
  fungi$output<-ifelse(fungi$biomass[,i]>0,1,0)
  fungi$output

  sum(fungi$output)
  sum(fungi$biomass[,i])
  sum(prey$alive==1)
  mean(prey$critical[prey$alive==1])
  sum(pred$alive==1)
  mean(pred$critical[pred$alive==1])

  pred$alive
  prey$alive
  pred$instar
  prey$instar

  write.table(TC,"medium_T_TC_w_preds.txt")   #entrem dades sense substituci a un fitxer nou i amb noms de variables
  write.table(prey,"medium_T_prey_w_preds.txt")   #entrem dades sense substituci a un fitxer nou i amb noms de variables
  write.table(pred,"medium_T_pred.txt")   #entrem dades sense substituci a un fitxer nou i amb noms de variables
  write.table(fungi,"medium_T_fungi_w_preds.txt")   #entrem
  write.table(all_prey,"medium_T_prey_genetics_w_preds.txt")
  write.table(all_preds,"medium_T_pred_genetics_w_preds.txt")

  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ############### HIGH T WITH PREDATORS ##########################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################

  
  prey_integration=switches$for_desintegration
  pred_integration=switches$for_desintegration
  predators=switches$predators
  rho_prey_2=switches$rho_prey_2
  rho_pred_2=switches$rho_pred_2
  T=switches$T3

  ##T=20
  min_r=exp(25.98-(0.68*(1/(0.0000862*(T+273.15)))))/((min_fungi*1000)^(1/4))  ##ind/indxday | Fig. 4 in Savage et al. 2004 Am. Nat.
  max_r=exp(25.98-(0.68*(1/(0.0000862*(T+273.15)))))/((max_fungi*1000)^(1/4))  ###it is a lower r when mass is larger





    ####TROPHIC CASCADE COLLECTOR##############
    ###########################################
    TC<-as.data.frame(matrix(nrow=steps,ncol=13))       ##this just collects the information on how fungi biomass changes from day to day
    names(TC)[1:13]<-c("BIOMASS","BIOMASS_OUT","PREY_EGGS","PREY_ALIVE","PREY_STARVED","PREY_PREDATED",
    "PREY_SENESCED","PREY_BMSS_OUT","PRED_EGGS","PRED_ALIVE","PRED_STARVED","PRED_PREDATED","PRED_SENESCED")

    ################# THE WORLD - N, SPACE AND TIME ########################################################
    ########################################################################################################
    World_size=as.integer(switches$World_size)      ###NUMBER OF CELLS SET UNIDIMENSIONALLY

    cells<-1:World_size

    cells<-as.data.frame(cells)

    n_prey=switches$n_prey#500*3                                    ###NUMBER OF PREY
    n_pred=switches$n_pred#281*3  # as.integer(round(n_prey*(1/10),0))     ###NUMBER OF PREDATORS


  seeds<-read.table("seeds.txt",header=T)
  seed_prey=seeds$seed_prey
  seed_pred=seeds$seed_pred


    ####fungi growth array
    fungi<-cells

     ##TO INCLUDE AUTOCORRELATION
    increase<-as.matrix(c(1:round(World_size/2,0)))
    decrease<-as.matrix(c(round(World_size/2,0):1))
    fungi$x<-as.matrix(rbind(increase,decrease))

    fungi$r<-interpol(fungi$x,min_r,max_r)


    fungi$ini<-interpol(fungi$x,min_fungi,max_fungi)
    fungi$K<-interpol(fungi$x,min_K,max_K)     ###########################################################################
    sum(fungi$K)

          ############################# TO REMOVE AUTOCORRELATION AND THE SAME r and ini ACROSS THE WORLD_SIZE CELLS #############################################
          if (autocor==0){
          names(fungi)

          set.seed(seed_prey)
          fungi$aleat<-runif(nrow(fungi))

          names(fungi)

          #[1] "cells" "r"     "ini"   "K" "aleat"

          r_sorted <- fungi[do.call(order,fungi[c(5)]),]  #finally how to sort in R

          r_sorted$orden<-as.numeric(World_size:1)

          r_sorted

          names(r_sorted)
          #[1] "cells" "r"     "ini"   "aleat" "orden"


          new_matrix<-as.data.frame(matrix(nrow=nrow(fungi),ncol=4))


          new_matrix[,1]=r_sorted$orden
          new_matrix[,2]=r_sorted$r
          new_matrix[,3]=r_sorted$ini
          new_matrix[,4]=r_sorted$K


          names(new_matrix)<-c("cells","r","ini","K")

          new_matrix

          fungi<-new_matrix[do.call(order,new_matrix[c(1)]),]

          }

  plot(fungi$cells,fungi$K)

  fungi$cells<-as.integer(fungi$cells)
  fungi$biomass_in<-matrix(nrow=nrow(fungi),ncol=steps)
  fungi$biomass_out<-matrix(nrow=nrow(fungi),ncol=steps)
  fungi$biomass<-matrix(nrow=nrow(fungi),ncol=steps)

  fungi$excess<-matrix(nrow=nrow(fungi),ncol=1,0)

    ##############################################################################################################################################
    ##############################################################################################################################################
    ##############################################################################################################################################
########################################################################
######################## TRAITS ########################################
########################################################################

  prey<-prey2
  prey_w_genes<-prey_w_genes2
  pred<-pred2
  pred_w_genes<-pred_w_genes2

  prey$pheno<-round(prey$pheno*interpol2(T,min_T,max_T,1,Q10pheno),0) ##to include Q10 in dev time
  pred$pheno<-round(pred$pheno*interpol2(T,min_T,max_T,1,Q10pheno),0)

    ##############################################################################################################################################
    ##############################################################################################################################################
    ##############################################################################################################################################


      ################# MAIN FUNCTION##################################

  for (i in 1:steps){ #steps   1 step equals 1 day

  fungi<-fungi_func(cells,fungi,i)
    total_biomass<-sum(fungi$biomass[,i])
    total_biomass_out<-sum(fungi$biomass_out[,i])
    TC$BIOMASS[i]<-total_biomass
    TC$BIOMASS_OUT[i]<-total_biomass_out
    TC$PREY_EGGS[i]<-sum(prey$alive==0)
    TC$PREY_ALIVE[i]<-sum(prey$alive==1)
    TC$PREY_STARVED[i]<-sum(prey$alive==2)
    TC$PREY_PREDATED[i]<-sum(prey$alive==3)
    TC$PREY_SENESCED[i]<-sum(prey$alive==6)
    if (predators==1){
    TC$PREY_BMSS_OUT[i]<-sum(pred$food_mass)
    TC$PRED_EGGS[i]<-sum(pred$alive==0)
    TC$PRED_ALIVE[i]<-sum(pred$alive==1)
    TC$PRED_STARVED[i]<-sum(pred$alive==2)
    TC$PRED_PREDATED[i]<-sum(pred$alive==3)
    TC$PRED_SENESCED[i]<-sum(pred$alive==6)
    }


 
     print("HIGH TEMPERATURE IN C - WITH PREDATORS")
     print(T)
     print("day")
     print(i)
     if (sum(fungi$biomass[,i])==0) stop("fungi_went_extint")

     prey$random<-runif(nrow(prey))
     prey<-prey[do.call(order,prey[c("random")]),]   ##shuffles the order in which each day each animal acts

     if (predators==1){
     pred$random<-runif(nrow(pred))
     pred<-pred[do.call(order,pred[c("random")]),]   ##shuffles the order in which each day each animal acts
     }

     prey<-tune_traits(prey,upper_tank_prey)
     prey<-tune_traits2(prey)

      prey$eaten<-0
     prey$encounters_pred<-0



     if (predators==1){
     pred<-tune_traits(pred,upper_tank_pred)
     pred<-tune_traits2(pred) #this will make only sense when predators feed on each other!!!!!!!!!!!
     pred$eating<-0
     pred$food_mass<-0
     pred$encounters_pred<-0
     pred$encounters_prey<-0
     pred$days_digest<-ifelse(pred$days_digest>0,pred$days_digest-1,0)
     }

     sum_prey_alive<-ifelse(prey$alive==1,1,0)
      if(i>9&sum(sum_prey_alive)==0) {
      write.table(prey,"prey_at_extintion.txt")  ##this is to estimate when prey are all killed (some may have reached adulthood and reproduced, though)
      write.table(i,"i_at_prey_extinction.txt")
      }      ##10 is max phenology for prey


     if (i>1)  ###controls when prey start mattering in the food web - here, one day after simulations start, so fungi have time to grow before depletion
     for (r in 1:nrow(prey)){

      if ((i>=prey$pheno[r])&&(prey$alive[r]==0)) {   ##when pheno (phenology) is reached, the day to be born has arrived and the animal activates
          prey$alive[r]=1
          }


      if (prey$alive[r]==1){

      if (predators==1){
      prey$pasos[r]<-0

      if (prey$search_area_tuned[r]>0){
      for (k in 1:prey$search_area_tuned[r]){ ###search_area_tuned - maximum number of steps to walk in one day (tick)

      if (prey$alive[r]==1){
      prey<-prey_mov(prey,pred,fungi,i,World_size,r)


      in_cell<-for_interaction(pred,prey,fungi,i,r)



      if (is.logical(in_cell)==F){


      in_cell<-predation_prey_move(in_cell,i)

      if(nrow(in_cell)>1){
      prey$alive[r]=in_cell$alive[1]
      prey$date_death[r]=in_cell$date_death[1]
      prey$encounters_pred[r]=prey$encounters_pred[r]+in_cell$encounters_pred[1]
      
      prey$global_pred_encs[r]=prey$global_pred_encs[r]+in_cell$encounters_pred[1]
     

      in_cell<-in_cell[2:nrow(in_cell),] ##Removes the prey from the first row



      for (dd in 1:nrow(in_cell)){
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell$ID[dd]){
      pred$encounters_prey[xx]<-pred$encounters_prey[xx]+in_cell$encounters_prey[dd]
      pred$global_prey_encs[xx]= pred$global_prey_encs[xx]+in_cell$encounters_prey[dd]
      pred$eating[xx]<-in_cell$eating[dd]
      pred$food_mass[xx]<-in_cell$food_mass[dd]
      }
      }
      }
      }
      }
      }
       }###end of moving for prey r in a World with predators
       }


      }else{
      prey$pasos[r]<-0

      if (prey$search_area_tuned[r]>0){
      for (k in 1:prey$search_area_tuned[r]){
      prey<-prey_mov(prey,fungi,i,World_size,r)

      }
      }
      }

      prey<-feed_prey(prey,i,fungi,par_food,eficiencia,upper_tank_prey,r)
      fungi<-fungi_eaten(prey,i,fungi,r,min_fungi,zero_fungi)




    prey<-metab_with_growth(prey,i,assigned,r,deadly_tank,upper_tank_prey)
      }
    }

      if (i>2)##controls when predators start mattering and moving in the food web
      if (predators==1){
      for (t in 1:nrow(pred)){
      if ((i>=pred$pheno[t])&&(pred$alive[t]==0)) {
          pred$alive[t]=1
          }

          if (pred$alive[t]==1&pred$days_digest[t]==0){
          pred<-pred_background(pred,i,t)
          if (pred$alive[t]==5) print(cbind("this one dies from background mortality",t))
          }

           sum_pred_alive<-ifelse(pred$alive==1,1,0)
          if (i>14&sum(sum_pred_alive)==0) stop("predators_went_extint") ##15 is max phenology for predator

      pred$pasos[t]<-0

          if (pred$search_area_tuned[t]>0&pred$alive[t]==1&pred$eating[t]==0&pred$days_digest[t]==0){          ###now, the predators that have not eaten yet, from prey moves, go out to hunt prey
          for (k in 1:pred$search_area_tuned[t]){
          
           if ((pred$days_digest[t]==0)&(pred$alive[t]==1)&(pred$eating[t]==0)){
 #
          pred<-pred_mov(prey,pred,fungi,i,World_size,t)
          
          

      in_cell_x1<-as.data.frame(for_interaction_x1(pred,fungi,t))

#
      if (is.logical(in_cell_x1)==F){

      in_cell_x1<-predation_prey_move(in_cell_x1,i)   ##this function is identical as the predator acts as prey passes in_cell_x1 but gets in_cell as in_cell_x1!!!!!

      if(nrow(in_cell_x1)>1){                       ###updates the target predator
      pred$alive[t]=in_cell_x1$alive[1]
      pred$date_death[t]=in_cell_x1$date_death[1]
      pred$encounters_pred[t]=pred$encounters_pred[t]+in_cell_x1$encounters_pred[1]
      pred$global_pred_encs[t]= pred$global_pred_encs[t]+in_cell_x1$encounters_pred[1]

      in_cell_x1<-in_cell_x1[2:nrow(in_cell_x1),] ##Removes the pred[t] from the first row


      for (dd in 1:nrow(in_cell_x1)){     ##updates predators as they may have encounter the predator acting as prey, feed upon it, etc.!!!!!!
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell_x1$ID[dd]){
      pred$encounters_prey[xx]<-pred$encounters_prey[xx]+in_cell_x1$encounters_prey[dd]
      pred$global_prey_encs[xx]= pred$global_prey_encs[xx]+in_cell_x1$encounters_prey[dd]
      pred$eating[xx]<-in_cell_x1$eating[dd]
      pred$food_mass[xx]<-in_cell_x1$food_mass[dd]
      }
      }
      }
      }
      }

      ##the following only happens if the predator is alive and we are going to update the predator status if killed while moving!!!!
      #

      if (pred$alive[t]==1){
      in_cell2<-as.data.frame(for_interaction2_x1(pred,prey,fungi,t))
#

      if (is.logical(in_cell2)==F){
      in_cell2<-predation_pred_move(in_cell2,i)
      
     


      if(nrow(in_cell2)>1){

      pred$encounters_prey[t]=pred$encounters_prey[t]+in_cell2$encounters_prey[1]
      pred$global_prey_encs[t]=pred$global_prey_encs[t]+pred$encounters_prey[1]
      pred$eating[t]<-in_cell2$eating[1]
      pred$food_mass[t]<-in_cell2$food_mass[1]
  
      #####NEW FOR SPIDERS - UPDATE PREDATORS FROM RETALIATION / SEE ALSO BELOW
      pred$alive[t]=in_cell2$alive[1]
      pred$date_death[t]=in_cell2$date_death[1]
  
      in_cell2<-in_cell2[2:nrow(in_cell2),] ##Removes the pred from the first row
 
      for (dd in 1:nrow(in_cell2)){         ###updates prey
      for (xx in 1:nrow(prey)){
      if(prey$ID[xx]==in_cell2$ID[dd]&!is.na(charmatch(prey$pred_prey[xx],in_cell2$pred_prey[dd]))&in_cell2$pred_prey[dd]=="prey"){  ###modified on 18_02_2012
      prey$encounters_pred[xx]<-prey$encounters_pred[xx]+in_cell2$encounters_pred[dd]
      prey$global_pred_encs[xx]<-prey$global_pred_encs[xx]+in_cell2$encounters_pred[dd]

      prey$alive[xx]=in_cell2$alive[dd]
      prey$date_death[xx]=in_cell2$date_death[dd]
      }
      }
      }

      ##soso_start##     ###predators that have potentially acted as prey should be updated for encounters and for status
      for (dd in 1:nrow(in_cell2)){   ###updates predators as if they were prey
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell2$ID[dd]&!is.na(charmatch(pred$pred_prey[xx],in_cell2$pred_prey[dd]))&in_cell2$pred_prey[dd]=="pred"){  ###modified on 18_02_2012
      pred$encounters_pred[xx]<-pred$encounters_pred[xx]+in_cell2$encounters_pred[dd]
      pred$global_pred_encs[xx]<-pred$global_pred_encs[xx]+in_cell2$encounters_pred[dd]
      pred$alive[xx]=in_cell2$alive[dd]
      pred$date_death[xx]=in_cell2$date_death[dd]
      
      ######AND ALSO UPDATE PREY AS IF THEY ARE PREDATORS WHEN RETALIATION OCCURS - INCLUDING ASSIMILATION FROM FEEDING!!!!
      pred$eating[xx]<-in_cell2$eating[dd]
      pred$food_mass[xx]<-in_cell2$food_mass[dd]
      pred<-pred_assim(pred,xx,upper_tank_pred)

      }
      }
      }
      }
      }
      }


          }

          }
          }


          if (pred$alive[t]==1&pred$eating[t]==1){
          pred<-pred_assim(pred,t,upper_tank_pred)
          }

          if (pred$alive[t]==1){   ##new in book chapter, even if it reproduces, it expends energy
          pred<-metab_with_growth(pred,i,assigned,t,deadly_tank,upper_tank_pred)
          }

          }
          }



     if(sum(prey$alive==4)>1){
     all_prey<-repro(TEMP=T,day=i,prey,prey_w_genes,mod_type1=prey_mod_int_1,mod_type2=prey_mod_int_2,
     mod_type3=prey_mod_int_3,mod_type4=prey_mod_int_4,rho=rho_prey)

     if (all_prey$pred_prey[1]=="prey"){
      prey_w_genes<-all_prey[,1:69]
      prey<-all_prey[,70:109]
      names(prey)[1:14]<-c("ID","energy_tank","voracity","speed","body_size","met_rate","growth"
      ,"search_area","assim","pheno","vorQ10","spdQ10","srchQ10","actE_met")
      }
      }



     if(predators==1)
     if(sum(pred$alive==4)>1){
     all_preds<-repro(TEMP=T,day=i,pred,pred_w_genes,mod_type1=pred_mod_int_1,mod_type2=pred_mod_int_2,
      mod_type3=pred_mod_int_3,mod_type4=pred_mod_int_4,rho=rho_pred)

     if (all_preds$pred_prey[1]=="pred"){
      pred_w_genes<-all_preds[,1:69]
      pred<-all_preds[,70:112]
      names(pred)[1:14]<-c("ID","energy_tank","voracity","speed","body_size","met_rate","growth"
      ,"search_area","assim","pheno","vorQ10","spdQ10","srchQ10","actE_met")
      }
      }



     prey<-prey[do.call(order,prey[c("ID")]),] ##sets the original ordering to the array
     if(predators==1)
     pred<-pred[do.call(order,pred[c("ID")]),] ##sets the original ordering to the array


    plot(fungi$cells,fungi$biomass[,i])
  }





  ####outputs
  fungi$output<-ifelse(fungi$biomass[,i]>0,1,0)
  fungi$output

  sum(fungi$output)
  sum(fungi$biomass[,i])
  sum(prey$alive==1)
  mean(prey$critical[prey$alive==1])
  sum(pred$alive==1)
  mean(pred$critical[pred$alive==1])

  pred$alive
  prey$alive
  pred$instar
  prey$instar

  write.table(TC,"high_T_TC_w_preds.txt")   #entrem dades sense substituci a un fitxer nou i amb noms de variables
  write.table(prey,"high_T_prey_w_preds.txt")   #entrem dades sense substituci a un fitxer nou i amb noms de variables
  write.table(pred,"high_T_pred.txt")   #entrem dades sense substituci a un fitxer nou i amb noms de variables
  write.table(fungi,"high_T_fungi_w_preds.txt")   #entrem
  write.table(all_prey,"high_T_prey_genetics_w_preds.txt")
  write.table(all_preds,"high_T_pred_genetics_w_preds.txt")

   ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  #################### LOW T NO PREDATORS ##########################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################

  prey_integration=switches$for_desintegration
  pred_integration=switches$for_desintegration
  predators=switches$predators2
  rho_prey_2=switches$rho_prey_2
  rho_pred_2=switches$rho_pred_2
  T=switches$T1

  ##T=20
  min_r=exp(25.98-(0.68*(1/(0.0000862*(T+273.15)))))/((min_fungi*1000)^(1/4))  ##ind/indxday | Fig. 4 in Savage et al. 2004 Am. Nat.
  max_r=exp(25.98-(0.68*(1/(0.0000862*(T+273.15)))))/((max_fungi*1000)^(1/4))  ###it is a lower r when mass is larger





  
  ###### prey moving algorithm when there are NOT predators around - at each movement (there can be more than one in one day-step) they move to immediate cells with more fungi
  prey_mov<-function(prey,fungi,i,World_size,j)
  {
  if (prey$coord_prey[j]==World_size){


       current_cell_b=interpol2(fungi$biomass[World_size,i],0,K,0.01,1)
       left_cell_b=interpol2(fungi$biomass[World_size-1,i],0,K,0.01,1)
       right_cell_b=interpol2(fungi$biomass[1,i],0,K,0.01,1)

       current_cell_r=1/current_cell_b
       left_cell_r=1/left_cell_b
       right_cell_r=1/right_cell_b



    if (current_cell_b == 0.01&current_cell_b == left_cell_b&right_cell_b == left_cell_b)
    {
     salto <-round(runif(1,min=2,max=prey$search_area_tuned[j]+2),0)  ##"salto" means "jump" in Spanish, when the cells to the right and to the left have no fungi, they jump longer distances
  
         valor<-runif(1)
         if (valor>0.4999){
         prey$coord_prey[j]<-salto
         prey$pasos[j]=salto
         }else{
         prey$coord_prey[j]<-World_size-salto
         prey$pasos[j]=salto
         }

    }else{
    if (right_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
         prey$coord_prey[j]=1
         prey$pasos[j]=prey$pasos[j]+1
    }else{
     if (left_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
        prey$coord_prey[j]=prey$coord_prey[j]-1
        prey$pasos[j]=prey$pasos[j]+1
     }
    }
    }

 }



    if (prey$coord_prey[j]==1){

       current_cell_b=interpol2(fungi$biomass[1,i],0,K,0.01,1)
       left_cell_b=interpol2(fungi$biomass[World_size,i],0,K,0.01,1)
       right_cell_b=interpol2(fungi$biomass[1+1,i],0,K,0.01,1)



       current_cell_r=1/current_cell_b
       left_cell_r=1/left_cell_b
       right_cell_r=1/right_cell_b




    if (current_cell_b == 0.01&current_cell_b == left_cell_b&right_cell_b == left_cell_b)
    {
     salto <-round(runif(1,min=2,max=prey$search_area_tuned[j]+2),0)  ##"salto" means "jump" in Spanish, when the cells to the right and to the left have no fungi, they jump longer distances

         valor<-runif(1)
         if (valor>0.4999)
         ((prey$coord_prey[j]<-salto+1) &
         (prey$pasos[j]=salto))
         if (valor<=0.4999)
         ((prey$coord_prey[j]<-(World_size+1)-salto)&
         (prey$pasos[j]=salto))
    }else{
     if (right_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
         prey$coord_prey[j]=1+1
         prey$pasos[j]=prey$pasos[j]+1
    }else{
     if (left_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
        prey$coord_prey[j]=World_size
        prey$pasos[j]=prey$pasos[j]+1
     }
    }

    }
   }




    if (prey$coord_prey[j]>1&prey$coord_prey[j]<World_size){

       current_cell_b=interpol2(fungi$biomass[prey$coord_prey[j],i],0,K,0.01,1)
       left_cell_b=interpol2(fungi$biomass[prey$coord_prey[j]-1,i],0,K,0.01,1)
       right_cell_b=interpol2(fungi$biomass[prey$coord_prey[j]+1,i],0,K,0.01,1)


       current_cell_r=1/current_cell_b
       left_cell_r=1/left_cell_b
       right_cell_r=1/right_cell_b



       if (current_cell_b == 0.01&current_cell_b == left_cell_b&right_cell_b == left_cell_b)
    {
     salto <-round(runif(1,min=2,max=prey$search_area_tuned[j]+2),0)  ##"salto" means "jump" in Spanish, when the cells to the right and to the left have no fungi, they jump longer distances
  
         valor<-runif(1)
         if (valor>0.4999)
         ((prey$coord_prey[j]<-prey$coord_prey[j]+salto) &
         (prey$pasos[j]=salto))
         if (valor<=0.4999)
         ((prey$coord_prey[j]<-prey$coord_prey[j]-salto)&
         (prey$pasos[j]=salto))
         if (prey$coord_prey[j]>World_size)                    ##if jumping occurs outside the World, makes it to return to the other end
         prey$coord_prey[j]=prey$coord_prey[j]-World_size
         if (prey$coord_prey[j]<1)
         prey$coord_prey[j]=World_size+prey$coord_prey[j]


    }else{
     if (right_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
         prey$coord_prey[j]=prey$coord_prey[j]+1
         prey$pasos[j]=prey$pasos[j]+1
    }else{
     if (left_cell_r==min(current_cell_r,left_cell_r,right_cell_r)){
        prey$coord_prey[j]=prey$coord_prey[j]-1
        prey$pasos[j]=prey$pasos[j]+1
     }
    }

    }
   }





   return(prey)
  }
  



 ########################################################################
######################## TRAITS ########################################
########################################################################

  prey<-prey2
  prey_w_genes<-prey_w_genes2
  pred<-pred2
  pred_w_genes<-pred_w_genes2

  prey$pheno<-round(prey$pheno*interpol2(T,min_T,max_T,1,Q10pheno),0) ##to include Q10 in dev time
  pred$pheno<-round(pred$pheno*interpol2(T,min_T,max_T,1,Q10pheno),0)

    ##############################################################################################################################################
    ##############################################################################################################################################
    ##############################################################################################################################################


    ####TROPHIC CASCADE COLLECTOR##############
    ###########################################
    TC<-as.data.frame(matrix(nrow=steps,ncol=13))       ##this just collects the information on how fungi biomass changes from day to day
    names(TC)[1:13]<-c("BIOMASS","BIOMASS_OUT","PREY_EGGS","PREY_ALIVE","PREY_STARVED","PREY_PREDATED",
    "PREY_SENESCED","PREY_BMSS_OUT","PRED_EGGS","PRED_ALIVE","PRED_STARVED","PRED_PREDATED","PRED_SENESCED")

    ################# THE WORLD - N, SPACE AND TIME ########################################################
    ########################################################################################################
    World_size=as.integer(switches$World_size)      ###NUMBER OF CELLS SET UNIDIMENSIONALLY

    cells<-1:World_size

    cells<-as.data.frame(cells)

    n_prey=switches$n_prey#500*3                                    ###NUMBER OF PREY
    n_pred=switches$n_pred#281*3  # as.integer(round(n_prey*(1/10),0))     ###NUMBER OF PREDATORS


  seeds<-read.table("seeds.txt",header=T)
  seed_prey=seeds$seed_prey
  seed_pred=seeds$seed_pred


    ####fungi growth array
    fungi<-cells

     ##TO INCLUDE AUTOCORRELATION
    increase<-as.matrix(c(1:round(World_size/2,0)))
    decrease<-as.matrix(c(round(World_size/2,0):1))
    fungi$x<-as.matrix(rbind(increase,decrease))

    fungi$r<-interpol(fungi$x,min_r,max_r)


    fungi$ini<-interpol(fungi$x,min_fungi,max_fungi)
    fungi$K<-interpol(fungi$x,min_K,max_K)     ###########################################################################
    sum(fungi$K)

          ############################# TO REMOVE AUTOCORRELATION AND THE SAME r and ini ACROSS THE WORLD_SIZE CELLS #############################################
          if (autocor==0){
          names(fungi)

          set.seed(seed_prey)
          fungi$aleat<-runif(nrow(fungi))

          names(fungi)

          #[1] "cells" "r"     "ini"   "K" "aleat"

          r_sorted <- fungi[do.call(order,fungi[c(5)]),]  #finally how to sort in R

          r_sorted$orden<-as.numeric(World_size:1)

          r_sorted

          names(r_sorted)
          #[1] "cells" "r"     "ini"   "aleat" "orden"


          new_matrix<-as.data.frame(matrix(nrow=nrow(fungi),ncol=4))


          new_matrix[,1]=r_sorted$orden
          new_matrix[,2]=r_sorted$r
          new_matrix[,3]=r_sorted$ini
          new_matrix[,4]=r_sorted$K


          names(new_matrix)<-c("cells","r","ini","K")

          new_matrix

          fungi<-new_matrix[do.call(order,new_matrix[c(1)]),]

          }

  plot(fungi$cells,fungi$K)

  fungi$cells<-as.integer(fungi$cells)
  fungi$biomass_in<-matrix(nrow=nrow(fungi),ncol=steps)
  fungi$biomass_out<-matrix(nrow=nrow(fungi),ncol=steps)
  fungi$biomass<-matrix(nrow=nrow(fungi),ncol=steps)

  fungi$excess<-matrix(nrow=nrow(fungi),ncol=1,0)

    ##############################################################################################################################################
    ##############################################################################################################################################
    ##############################################################################################################################################


      ################# MAIN FUNCTION##################################

  for (i in 1:steps){ #steps   1 step equals 1 day

  fungi<-fungi_func(cells,fungi,i)
    total_biomass<-sum(fungi$biomass[,i])
    total_biomass_out<-sum(fungi$biomass_out[,i])
    TC$BIOMASS[i]<-total_biomass
    TC$BIOMASS_OUT[i]<-total_biomass_out
    TC$PREY_EGGS[i]<-sum(prey$alive==0)
    TC$PREY_ALIVE[i]<-sum(prey$alive==1)
    TC$PREY_STARVED[i]<-sum(prey$alive==2)
    TC$PREY_PREDATED[i]<-sum(prey$alive==3)
    TC$PREY_SENESCED[i]<-sum(prey$alive==6)
    if (predators==1){
    TC$PREY_BMSS_OUT[i]<-sum(pred$food_mass)
    TC$PRED_EGGS[i]<-sum(pred$alive==0)
    TC$PRED_ALIVE[i]<-sum(pred$alive==1)
    TC$PRED_STARVED[i]<-sum(pred$alive==2)
    TC$PRED_PREDATED[i]<-sum(pred$alive==3)
    TC$PRED_SENESCED[i]<-sum(pred$alive==6)
    }


     #print("fungi")
     ##plot(fungi$cells,fungi$biomass[,i])
     print("LOW TEMPERATURE IN C - WITHOUT PREDATORS")
     print(T)
     print("day")
     print(i)
     if (sum(fungi$biomass[,i])==0) stop("fungi_went_extint")

     prey$random<-runif(nrow(prey))
     prey<-prey[do.call(order,prey[c("random")]),]   ##shuffles the order in which each day each animal acts

     if (predators==1){
     pred$random<-runif(nrow(pred))
     pred<-pred[do.call(order,pred[c("random")]),]   ##shuffles the order in which each day each animal acts
     }

     prey<-tune_traits(prey,upper_tank_prey)
     prey<-tune_traits2(prey)


     prey$eaten<-0
     prey$encounters_pred<-0



     if (predators==1){
     pred<-tune_traits(pred,upper_tank_pred)
     pred<-tune_traits2(pred) #this will make only sense when predators feed on each other!!!!!!!!!!!
     pred$eating<-0
     pred$food_mass<-0
     pred$encounters_pred<-0
     pred$encounters_prey<-0
     pred$days_digest<-ifelse(pred$days_digest>0,pred$days_digest-1,0)
     }

     sum_prey_alive<-ifelse(prey$alive==1,1,0)
      if(i>9&sum(sum_prey_alive)==0) {
      write.table(prey,"prey_at_extintion.txt")  ##this is to estimate when prey are all killed (some may have reached adulthood and reproduced, though)
      write.table(i,"i_at_prey_extinction.txt")
      }      ##10 is max phenology for prey


     if (i>1)  ###controls when prey start mattering in the food web - here, one day after simulations start, so fungi have time to grow before depletion
     for (r in 1:nrow(prey)){

      if ((i>=prey$pheno[r])&&(prey$alive[r]==0)) {   ##when pheno (phenology) is reached, the day to be born has arrived and the animal activates
          prey$alive[r]=1
          }


      if (prey$alive[r]==1){


      if (predators==1){
      prey$pasos[r]<-0

      if (prey$search_area_tuned[r]>0){
      for (k in 1:prey$search_area_tuned[r]){ ###search_area_tuned - maximum number of steps to walk in one day (tick)

      if (prey$alive[r]==1){
      prey<-prey_mov(prey,pred,fungi,i,World_size,r)


      in_cell<-for_interaction(pred,prey,fungi,i,r)



      if (is.logical(in_cell)==F){


      in_cell<-predation_prey_move(in_cell,i)

      if(nrow(in_cell)>1){
      prey$alive[r]=in_cell$alive[1]
      prey$date_death[r]=in_cell$date_death[1]
      prey$encounters_pred[r]=prey$encounters_pred[r]+in_cell$encounters_pred[1]
   
      prey$global_pred_encs[r]=prey$global_pred_encs[r]+in_cell$encounters_pred[1]
     
      in_cell<-in_cell[2:nrow(in_cell),] ##Removes the prey from the first row



      for (dd in 1:nrow(in_cell)){
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell$ID[dd]){
      pred$encounters_prey[xx]<-pred$encounters_prey[xx]+in_cell$encounters_prey[dd]
      pred$global_prey_encs[xx]= pred$global_prey_encs[xx]+in_cell$encounters_prey[dd]
      pred$eating[xx]<-in_cell$eating[dd]
      pred$food_mass[xx]<-in_cell$food_mass[dd]
      }
      }
      }
      }
      }
      }
      }###end of moving for prey r in a World with predators
      }


      }else{
      prey$pasos[r]<-0

      if (prey$search_area_tuned[r]>0){
      for (k in 1:prey$search_area_tuned[r]){
      prey<-prey_mov(prey,fungi,i,World_size,r)

      }
      }
      }

      prey<-feed_prey(prey,i,fungi,par_food,eficiencia,upper_tank_prey,r)
      fungi<-fungi_eaten(prey,i,fungi,r,min_fungi,zero_fungi)




    prey<-metab_with_growth(prey,i,assigned,r,deadly_tank,upper_tank_prey)
      }
    }

      if (i>2)##controls when predators start mattering and moving in the food web
      if (predators==1){
      for (t in 1:nrow(pred)){
      if ((i>=pred$pheno[t])&&(pred$alive[t]==0)) {
          pred$alive[t]=1
          }

          if (pred$alive[t]==1&pred$days_digest[t]==0){
          pred<-pred_background(pred,i,t)
          if (pred$alive[t]==5) print(cbind("this one dies from background mortality",t))
          }

           sum_pred_alive<-ifelse(pred$alive==1,1,0)
          if (i>14&sum(sum_pred_alive)==0) stop("predators_went_extint") ##15 is max phenology for predator

      pred$pasos[t]<-0

          if (pred$search_area_tuned[t]>0&pred$alive[t]==1&pred$eating[t]==0&pred$days_digest[t]==0){          ###now, the predators that have not eaten yet, from prey moves, go out to hunt prey
          for (k in 1:pred$search_area_tuned[t]){
          
           if ((pred$days_digest[t]==0)&(pred$alive[t]==1)&(pred$eating[t]==0)){
 #
          pred<-pred_mov(prey,pred,fungi,i,World_size,t)
          
          

      in_cell_x1<-as.data.frame(for_interaction_x1(pred,fungi,t))

#
      if (is.logical(in_cell_x1)==F){

      in_cell_x1<-predation_prey_move(in_cell_x1,i)   ##this function is identical as the predator acts as prey passes in_cell_x1 but gets in_cell as in_cell_x1!!!!!

      if(nrow(in_cell_x1)>1){                       ###updates the target predator
      pred$alive[t]=in_cell_x1$alive[1]
      pred$date_death[t]=in_cell_x1$date_death[1]
      pred$encounters_pred[t]=pred$encounters_pred[t]+in_cell_x1$encounters_pred[1]
      pred$global_pred_encs[t]= pred$global_pred_encs[t]+in_cell_x1$encounters_pred[1]

      in_cell_x1<-in_cell_x1[2:nrow(in_cell_x1),] ##Removes the pred[t] from the first row


      for (dd in 1:nrow(in_cell_x1)){     ##updates predators as they may have encounter the predator acting as prey, feed upon it, etc.!!!!!!
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell_x1$ID[dd]){
      pred$encounters_prey[xx]<-pred$encounters_prey[xx]+in_cell_x1$encounters_prey[dd]
      pred$global_prey_encs[xx]= pred$global_prey_encs[xx]+in_cell_x1$encounters_prey[dd]
      pred$eating[xx]<-in_cell_x1$eating[dd]
      pred$food_mass[xx]<-in_cell_x1$food_mass[dd]
      }
      }
      }
      }
      }

      ##the following only happens if the predator is alive and we are going to update the predator status if killed while moving!!!!
      #

      if (pred$alive[t]==1){
      in_cell2<-as.data.frame(for_interaction2_x1(pred,prey,fungi,t))

      if (is.logical(in_cell2)==F){
      in_cell2<-predation_pred_move(in_cell2,i)
      
     


      if(nrow(in_cell2)>1){

      pred$encounters_prey[t]=pred$encounters_prey[t]+in_cell2$encounters_prey[1]
      pred$global_prey_encs[t]=pred$global_prey_encs[t]+pred$encounters_prey[1]
      pred$eating[t]<-in_cell2$eating[1]
      pred$food_mass[t]<-in_cell2$food_mass[1]
  
      #####NEW FOR SPIDERS - UPDATE PREDATORS FROM RETALIATION / SEE ALSO BELOW
      pred$alive[t]=in_cell2$alive[1]
      pred$date_death[t]=in_cell2$date_death[1]
  
      in_cell2<-in_cell2[2:nrow(in_cell2),] ##Removes the pred from the first row

      for (dd in 1:nrow(in_cell2)){         ###updates prey
      for (xx in 1:nrow(prey)){
      if(prey$ID[xx]==in_cell2$ID[dd]&!is.na(charmatch(prey$pred_prey[xx],in_cell2$pred_prey[dd]))&in_cell2$pred_prey[dd]=="prey"){  ###modified on 18_02_2012
      prey$encounters_pred[xx]<-prey$encounters_pred[xx]+in_cell2$encounters_pred[dd]
      prey$global_pred_encs[xx]<-prey$global_pred_encs[xx]+in_cell2$encounters_pred[dd]

      prey$alive[xx]=in_cell2$alive[dd]
      prey$date_death[xx]=in_cell2$date_death[dd]
      }
      }
      }

   ###predators that have potentially acted as prey should be updated for encounters and for status
      for (dd in 1:nrow(in_cell2)){   ###updates predators as if they were prey
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell2$ID[dd]&!is.na(charmatch(pred$pred_prey[xx],in_cell2$pred_prey[dd]))&in_cell2$pred_prey[dd]=="pred"){  ###modified on 18_02_2012
      pred$encounters_pred[xx]<-pred$encounters_pred[xx]+in_cell2$encounters_pred[dd]
      pred$global_pred_encs[xx]<-pred$global_pred_encs[xx]+in_cell2$encounters_pred[dd]
      pred$alive[xx]=in_cell2$alive[dd]
      pred$date_death[xx]=in_cell2$date_death[dd]
      
      ######AND ALSO UPDATE PREY AS IF THEY ARE PREDATORS WHEN RETALIATION OCCURS - INCLUDING ASSIMILATION FROM FEEDING!!!!
      pred$eating[xx]<-in_cell2$eating[dd]
      pred$food_mass[xx]<-in_cell2$food_mass[dd]
      pred<-pred_assim(pred,xx,upper_tank_pred)

      }
      }
      }


      }
      }
      }


          }

          }
          }


          if (pred$alive[t]==1&pred$eating[t]==1){
          pred<-pred_assim(pred,t,upper_tank_pred)
          }

          if (pred$alive[t]==1){   ##new in book chapter, even if it reproduces, it expends energy
          pred<-metab_with_growth(pred,i,assigned,t,deadly_tank,upper_tank_pred)
          }

          }
          }



     if(sum(prey$alive==4)>1){
     all_prey<-repro(TEMP=T,day=i,prey,prey_w_genes,mod_type1=prey_mod_int_1,mod_type2=prey_mod_int_2,
     mod_type3=prey_mod_int_3,mod_type4=prey_mod_int_4,rho=rho_prey)

     if (all_prey$pred_prey[1]=="prey"){
      prey_w_genes<-all_prey[,1:69]
      prey<-all_prey[,70:109]
      names(prey)[1:14]<-c("ID","energy_tank","voracity","speed","body_size","met_rate","growth"
      ,"search_area","assim","pheno","vorQ10","spdQ10","srchQ10","actE_met")
      }
      }



     if(predators==1)
     if(sum(pred$alive==4)>1){
     all_preds<-repro(TEMP=T,day=i,pred,pred_w_genes,mod_type1=pred_mod_int_1,mod_type2=pred_mod_int_2,
      mod_type3=pred_mod_int_3,mod_type4=pred_mod_int_4,rho=rho_pred)

     if (all_preds$pred_prey[1]=="pred"){
      pred_w_genes<-all_preds[,1:69]
      pred<-all_preds[,70:112]
      names(pred)[1:14]<-c("ID","energy_tank","voracity","speed","body_size","met_rate","growth"
      ,"search_area","assim","pheno","vorQ10","spdQ10","srchQ10","actE_met")
      }
      }



     prey<-prey[do.call(order,prey[c("ID")]),] ##sets the original ordering to the array
     if(predators==1)
     pred<-pred[do.call(order,pred[c("ID")]),] ##sets the original ordering to the array



    plot(fungi$cells,fungi$biomass[,i])
  }




  ####outputs
  fungi$output<-ifelse(fungi$biomass[,i]>0,1,0)
  fungi$output

  sum(fungi$output)
  sum(fungi$biomass[,i])
  sum(prey$alive==1)
  mean(prey$critical[prey$alive==1])
  sum(pred$alive==1)
  mean(pred$critical[pred$alive==1])

  pred$alive
  prey$alive
  pred$instar
  prey$instar

  write.table(TC,"low_T_TC_no_preds.txt")   #entrem dades sense substituci a un fitxer nou i amb noms de variables
  write.table(prey,"low_T_prey_no_preds.txt")   #entrem dades sense substituci a un fitxer nou i amb noms de variables
  write.table(fungi,"low_T_fungi_no_preds.txt")   #entrem
  write.table(all_prey,"low_T_prey_genetics_no_preds.txt")

  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###################### MEDIUM T NO PREDATORS #####################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  prey_integration=switches$for_desintegration
  pred_integration=switches$for_desintegration
  predators=switches$predators2
  rho_prey_2=switches$rho_prey_2
  rho_pred_2=switches$rho_pred_2
  T=switches$T2

  ##T=20
  min_r=exp(25.98-(0.68*(1/(0.0000862*(T+273.15)))))/((min_fungi*1000)^(1/4))  ##ind/indxday | Fig. 4 in Savage et al. 2004 Am. Nat.
  max_r=exp(25.98-(0.68*(1/(0.0000862*(T+273.15)))))/((max_fungi*1000)^(1/4))  ###it is a lower r when mass is larger


 


    ####TROPHIC CASCADE COLLECTOR##############
    ###########################################
    TC<-as.data.frame(matrix(nrow=steps,ncol=13))       ##this just collects the information on how fungi biomass changes from day to day
    names(TC)[1:13]<-c("BIOMASS","BIOMASS_OUT","PREY_EGGS","PREY_ALIVE","PREY_STARVED","PREY_PREDATED",
    "PREY_SENESCED","PREY_BMSS_OUT","PRED_EGGS","PRED_ALIVE","PRED_STARVED","PRED_PREDATED","PRED_SENESCED")

    ################# THE WORLD - N, SPACE AND TIME ########################################################
    ########################################################################################################
    World_size=as.integer(switches$World_size)      ###NUMBER OF CELLS SET UNIDIMENSIONALLY

    cells<-1:World_size

    cells<-as.data.frame(cells)

    n_prey=switches$n_prey#500*3                                    ###NUMBER OF PREY
    n_pred=switches$n_pred#281*3  # as.integer(round(n_prey*(1/10),0))     ###NUMBER OF PREDATORS


  seeds<-read.table("seeds.txt",header=T)
  seed_prey=seeds$seed_prey
  seed_pred=seeds$seed_pred


    ####fungi growth array
    fungi<-cells

     ##TO INCLUDE AUTOCORRELATION
    increase<-as.matrix(c(1:round(World_size/2,0)))
    decrease<-as.matrix(c(round(World_size/2,0):1))
    fungi$x<-as.matrix(rbind(increase,decrease))

    fungi$r<-interpol(fungi$x,min_r,max_r)


    fungi$ini<-interpol(fungi$x,min_fungi,max_fungi)
    fungi$K<-interpol(fungi$x,min_K,max_K)     ###########################################################################
    sum(fungi$K)

          ############################# TO REMOVE AUTOCORRELATION AND THE SAME r and ini ACROSS THE WORLD_SIZE CELLS #############################################
          if (autocor==0){
          names(fungi)

          set.seed(seed_prey)
          fungi$aleat<-runif(nrow(fungi))

          names(fungi)

          #[1] "cells" "r"     "ini"   "K" "aleat"

          r_sorted <- fungi[do.call(order,fungi[c(5)]),]  #finally how to sort in R

          r_sorted$orden<-as.numeric(World_size:1)

          r_sorted

          names(r_sorted)
          #[1] "cells" "r"     "ini"   "aleat" "orden"


          new_matrix<-as.data.frame(matrix(nrow=nrow(fungi),ncol=4))


          new_matrix[,1]=r_sorted$orden
          new_matrix[,2]=r_sorted$r
          new_matrix[,3]=r_sorted$ini
          new_matrix[,4]=r_sorted$K


          names(new_matrix)<-c("cells","r","ini","K")

          new_matrix

          fungi<-new_matrix[do.call(order,new_matrix[c(1)]),]

          }

  plot(fungi$cells,fungi$K)

  fungi$cells<-as.integer(fungi$cells)
  fungi$biomass_in<-matrix(nrow=nrow(fungi),ncol=steps)
  fungi$biomass_out<-matrix(nrow=nrow(fungi),ncol=steps)
  fungi$biomass<-matrix(nrow=nrow(fungi),ncol=steps)

  fungi$excess<-matrix(nrow=nrow(fungi),ncol=1,0)


   ########################################################################
######################## TRAITS ########################################
########################################################################

  prey<-prey2
  prey_w_genes<-prey_w_genes2
  pred<-pred2
  pred_w_genes<-pred_w_genes2

  prey$pheno<-round(prey$pheno*interpol2(T,min_T,max_T,1,Q10pheno),0) ##to include Q10 in dev time
  pred$pheno<-round(pred$pheno*interpol2(T,min_T,max_T,1,Q10pheno),0)

    ##############################################################################################################################################
    ##############################################################################################################################################
    ##############################################################################################################################################

    ##############################################################################################################################################
    ##############################################################################################################################################
    ##############################################################################################################################################


      ################# MAIN FUNCTION##################################

  for (i in 1:steps){ #steps   1 step equals 1 day

  fungi<-fungi_func(cells,fungi,i)
    total_biomass<-sum(fungi$biomass[,i])
    total_biomass_out<-sum(fungi$biomass_out[,i])
    TC$BIOMASS[i]<-total_biomass
    TC$BIOMASS_OUT[i]<-total_biomass_out
    TC$PREY_EGGS[i]<-sum(prey$alive==0)
    TC$PREY_ALIVE[i]<-sum(prey$alive==1)
    TC$PREY_STARVED[i]<-sum(prey$alive==2)
    TC$PREY_PREDATED[i]<-sum(prey$alive==3)
    TC$PREY_SENESCED[i]<-sum(prey$alive==6)
    if (predators==1){
    TC$PREY_BMSS_OUT[i]<-sum(pred$food_mass)
    TC$PRED_EGGS[i]<-sum(pred$alive==0)
    TC$PRED_ALIVE[i]<-sum(pred$alive==1)
    TC$PRED_STARVED[i]<-sum(pred$alive==2)
    TC$PRED_PREDATED[i]<-sum(pred$alive==3)
    TC$PRED_SENESCED[i]<-sum(pred$alive==6)
    }


     #print("fungi")
     ##plot(fungi$cells,fungi$biomass[,i])
     print("MID TEMPERATURE IN C - WITHOUT PREDATORS")
     print(T)
     print("day")
     print(i)
     if (sum(fungi$biomass[,i])==0) stop("fungi_went_extint")

     prey$random<-runif(nrow(prey))
     prey<-prey[do.call(order,prey[c("random")]),]   ##shuffles the order in which each day each animal acts

     if (predators==1){
     pred$random<-runif(nrow(pred))
     pred<-pred[do.call(order,pred[c("random")]),]   ##shuffles the order in which each day each animal acts
     }

     prey<-tune_traits(prey,upper_tank_prey)
     prey<-tune_traits2(prey)

     prey$eaten<-0
     prey$encounters_pred<-0



     if (predators==1){
     pred<-tune_traits(pred,upper_tank_pred)
     pred<-tune_traits2(pred) #this will make only sense when predators feed on each other!!!!!!!!!!!
     pred$eating<-0
     pred$food_mass<-0
     pred$encounters_pred<-0
     pred$encounters_prey<-0
     pred$days_digest<-ifelse(pred$days_digest>0,pred$days_digest-1,0)
     }

     sum_prey_alive<-ifelse(prey$alive==1,1,0)
      if(i>9&sum(sum_prey_alive)==0) {
      write.table(prey,"prey_at_extintion.txt")  ##this is to estimate when prey are all killed (some may have reached adulthood and reproduced, though)
      write.table(i,"i_at_prey_extinction.txt")
      }      ##10 is max phenology for prey


     if (i>1)  ###controls when prey start mattering in the food web - here, one day after simulations start, so fungi have time to grow before depletion
     for (r in 1:nrow(prey)){

      if ((i>=prey$pheno[r])&&(prey$alive[r]==0)) {   ##when pheno (phenology) is reached, the day to be born has arrived and the animal activates
          prey$alive[r]=1
          }


      if (prey$alive[r]==1){

  

      if (predators==1){
      prey$pasos[r]<-0

      if (prey$search_area_tuned[r]>0){
      for (k in 1:prey$search_area_tuned[r]){ ###search_area_tuned - maximum number of steps to walk in one day (tick)

      if (prey$alive[r]==1){
      prey<-prey_mov(prey,pred,fungi,i,World_size,r)


      in_cell<-for_interaction(pred,prey,fungi,i,r)



      if (is.logical(in_cell)==F){


      in_cell<-predation_prey_move(in_cell,i)

      if(nrow(in_cell)>1){
      prey$alive[r]=in_cell$alive[1]
      prey$date_death[r]=in_cell$date_death[1]
      prey$encounters_pred[r]=prey$encounters_pred[r]+in_cell$encounters_pred[1]
    
      prey$global_pred_encs[r]=prey$global_pred_encs[r]+in_cell$encounters_pred[1]
    
      in_cell<-in_cell[2:nrow(in_cell),] ##Removes the prey from the first row



      for (dd in 1:nrow(in_cell)){
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell$ID[dd]){
      pred$encounters_prey[xx]<-pred$encounters_prey[xx]+in_cell$encounters_prey[dd]
      pred$global_prey_encs[xx]= pred$global_prey_encs[xx]+in_cell$encounters_prey[dd]
      pred$eating[xx]<-in_cell$eating[dd]
      pred$food_mass[xx]<-in_cell$food_mass[dd]
      }
      }
      }
      }
      }
      }
      }###end of moving for prey r in a World with predators
      }


      }else{
      prey$pasos[r]<-0

      if (prey$search_area_tuned[r]>0){
      for (k in 1:prey$search_area_tuned[r]){
      prey<-prey_mov(prey,fungi,i,World_size,r)

      }
      }
      }

      prey<-feed_prey(prey,i,fungi,par_food,eficiencia,upper_tank_prey,r)
      fungi<-fungi_eaten(prey,i,fungi,r,min_fungi,zero_fungi)




    prey<-metab_with_growth(prey,i,assigned,r,deadly_tank,upper_tank_prey)
      }
    }

      if (i>2)##controls when predators start mattering and moving in the food web
      if (predators==1){
      for (t in 1:nrow(pred)){
      if ((i>=pred$pheno[t])&&(pred$alive[t]==0)) {
          pred$alive[t]=1
          }

          if (pred$alive[t]==1&pred$days_digest[t]==0){
          pred<-pred_background(pred,i,t)
          if (pred$alive[t]==5) print(cbind("this one dies from background mortality",t))
          }

           sum_pred_alive<-ifelse(pred$alive==1,1,0)
          if (i>14&sum(sum_pred_alive)==0) stop("predators_went_extint") ##15 is max phenology for predator

      pred$pasos[t]<-0

          if (pred$search_area_tuned[t]>0&pred$alive[t]==1&pred$eating[t]==0&pred$days_digest[t]==0){          ###now, the predators that have not eaten yet, from prey moves, go out to hunt prey
          for (k in 1:pred$search_area_tuned[t]){
          
          if ((pred$days_digest[t]==0)&(pred$alive[t]==1)&(pred$eating[t]==0)){
#
          pred<-pred_mov(prey,pred,fungi,i,World_size,t)
          
          
      in_cell_x1<-as.data.frame(for_interaction_x1(pred,fungi,t))

#
      if (is.logical(in_cell_x1)==F){

      in_cell_x1<-predation_prey_move(in_cell_x1,i)   ##this function is identical as the predator acts as prey passes in_cell_x1 but gets in_cell as in_cell_x1!!!!!

       if(nrow(in_cell_x1)>1){                       ###updates the target predator
      pred$alive[t]=in_cell_x1$alive[1]
      pred$date_death[t]=in_cell_x1$date_death[1]
      pred$encounters_pred[t]=pred$encounters_pred[t]+in_cell_x1$encounters_pred[1]
      pred$global_pred_encs[t]= pred$global_pred_encs[t]+in_cell_x1$encounters_pred[1]

      in_cell_x1<-in_cell_x1[2:nrow(in_cell_x1),] ##Removes the pred[t] from the first row


      for (dd in 1:nrow(in_cell_x1)){     ##updates predators as they may have encounter the predator acting as prey, feed upon it, etc.!!!!!!
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell_x1$ID[dd]){
      pred$encounters_prey[xx]<-pred$encounters_prey[xx]+in_cell_x1$encounters_prey[dd]
      pred$global_prey_encs[xx]= pred$global_prey_encs[xx]+in_cell_x1$encounters_prey[dd]
      pred$eating[xx]<-in_cell_x1$eating[dd]
      pred$food_mass[xx]<-in_cell_x1$food_mass[dd]
      }
      }
      }
      }
      }

       ##the following only happens if the predator is alive and we are going to update the predator status if killed while moving!!!!
      #

      if (pred$alive[t]==1){
      in_cell2<-as.data.frame(for_interaction2_x1(pred,prey,fungi,t))

      if (is.logical(in_cell2)==F){
      in_cell2<-predation_pred_move(in_cell2,i)
      
     


      if(nrow(in_cell2)>1){

      pred$encounters_prey[t]=pred$encounters_prey[t]+in_cell2$encounters_prey[1]
      pred$global_prey_encs[t]=pred$global_prey_encs[t]+pred$encounters_prey[1]
      pred$eating[t]<-in_cell2$eating[1]
      pred$food_mass[t]<-in_cell2$food_mass[1]
   
      #####NEW FOR SPIDERS - UPDATE PREDATORS FROM RETALIATION / SEE ALSO BELOW
      pred$alive[t]=in_cell2$alive[1]
      pred$date_death[t]=in_cell2$date_death[1]
  
      in_cell2<-in_cell2[2:nrow(in_cell2),] ##Removes the pred from the first row
 
      for (dd in 1:nrow(in_cell2)){         ###updates prey
      for (xx in 1:nrow(prey)){
      if(prey$ID[xx]==in_cell2$ID[dd]&!is.na(charmatch(prey$pred_prey[xx],in_cell2$pred_prey[dd]))&in_cell2$pred_prey[dd]=="prey"){  ###modified on 18_02_2012
      prey$encounters_pred[xx]<-prey$encounters_pred[xx]+in_cell2$encounters_pred[dd]
      prey$global_pred_encs[xx]<-prey$global_pred_encs[xx]+in_cell2$encounters_pred[dd]

      prey$alive[xx]=in_cell2$alive[dd]
      prey$date_death[xx]=in_cell2$date_death[dd]
      }
      }
      }

      ###predators that have potentially acted as prey should be updated for encounters and for status
      for (dd in 1:nrow(in_cell2)){   ###updates predators as if they were prey
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell2$ID[dd]&!is.na(charmatch(pred$pred_prey[xx],in_cell2$pred_prey[dd]))&in_cell2$pred_prey[dd]=="pred"){  ###modified on 18_02_2012
      pred$encounters_pred[xx]<-pred$encounters_pred[xx]+in_cell2$encounters_pred[dd]
      pred$global_pred_encs[xx]<-pred$global_pred_encs[xx]+in_cell2$encounters_pred[dd]
      pred$alive[xx]=in_cell2$alive[dd]
      pred$date_death[xx]=in_cell2$date_death[dd]
      
      ######AND ALSO UPDATE PREY AS IF THEY ARE PREDATORS WHEN RETALIATION OCCURS - INCLUDING ASSIMILATION FROM FEEDING!!!!
      pred$eating[xx]<-in_cell2$eating[dd]
      pred$food_mass[xx]<-in_cell2$food_mass[dd]
      pred<-pred_assim(pred,xx,upper_tank_pred)

      }
      }
      }

      }
      }
      }


          }

          }
          }


          if (pred$alive[t]==1&pred$eating[t]==1){
          pred<-pred_assim(pred,t,upper_tank_pred)
          }

          if (pred$alive[t]==1){   ##new in book chapter, even if it reproduces, it expends energy
          pred<-metab_with_growth(pred,i,assigned,t,deadly_tank,upper_tank_pred)
          }

          }
          }



     if(sum(prey$alive==4)>1){
     all_prey<-repro(TEMP=T,day=i,prey,prey_w_genes,mod_type1=prey_mod_int_1,mod_type2=prey_mod_int_2,
     mod_type3=prey_mod_int_3,mod_type4=prey_mod_int_4,rho=rho_prey)

     if (all_prey$pred_prey[1]=="prey"){
      prey_w_genes<-all_prey[,1:69]
      prey<-all_prey[,70:109]
      names(prey)[1:14]<-c("ID","energy_tank","voracity","speed","body_size","met_rate","growth"
      ,"search_area","assim","pheno","vorQ10","spdQ10","srchQ10","actE_met")
      }
      }



     if(predators==1)
     if(sum(pred$alive==4)>1){
     all_preds<-repro(TEMP=T,day=i,pred,pred_w_genes,mod_type1=pred_mod_int_1,mod_type2=pred_mod_int_2,
      mod_type3=pred_mod_int_3,mod_type4=pred_mod_int_4,rho=rho_pred)

     if (all_preds$pred_prey[1]=="pred"){
      pred_w_genes<-all_preds[,1:69]
      pred<-all_preds[,70:112]
      names(pred)[1:14]<-c("ID","energy_tank","voracity","speed","body_size","met_rate","growth"
      ,"search_area","assim","pheno","vorQ10","spdQ10","srchQ10","actE_met")
      }
      }



     prey<-prey[do.call(order,prey[c("ID")]),] ##sets the original ordering to the array
     if(predators==1)
     pred<-pred[do.call(order,pred[c("ID")]),] ##sets the original ordering to the array


    plot(fungi$cells,fungi$biomass[,i])
  }





  ####outputs
  fungi$output<-ifelse(fungi$biomass[,i]>0,1,0)
  fungi$output

  sum(fungi$output)
  sum(fungi$biomass[,i])
  sum(prey$alive==1)
  mean(prey$critical[prey$alive==1])
  sum(pred$alive==1)
  mean(pred$critical[pred$alive==1])

  pred$alive
  prey$alive
  pred$instar
  prey$instar

  write.table(TC,"medium_T_TC_no_preds.txt")   #entrem dades sense substituci a un fitxer nou i amb noms de variables
  write.table(prey,"medium_T_prey_no_preds.txt")   #entrem dades sense substituci a un fitxer nou i amb noms de variables
  write.table(fungi,"medium_T_fungi_no_preds.txt")   #entrem
  write.table(all_prey,"medium_T_prey_genetics_no_preds.txt")

  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ################## HIGH T NO PREDATORS #####################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
  ###########################################################################################################################
    prey_integration=switches$for_desintegration
  pred_integration=switches$for_desintegration
  predators=switches$predators2
  rho_prey_2=switches$rho_prey_2
  rho_pred_2=switches$rho_pred_2
  T=switches$T3

  ##T=20
  min_r=exp(25.98-(0.68*(1/(0.0000862*(T+273.15)))))/((min_fungi*1000)^(1/4))  ##ind/indxday | Fig. 4 in Savage et al. 2004 Am. Nat.
  max_r=exp(25.98-(0.68*(1/(0.0000862*(T+273.15)))))/((max_fungi*1000)^(1/4))  ###it is a lower r when mass is larger



    ####TROPHIC CASCADE COLLECTOR##############
    ###########################################
    TC<-as.data.frame(matrix(nrow=steps,ncol=13))       ##this just collects the information on how fungi biomass changes from day to day
    names(TC)[1:13]<-c("BIOMASS","BIOMASS_OUT","PREY_EGGS","PREY_ALIVE","PREY_STARVED","PREY_PREDATED",
    "PREY_SENESCED","PREY_BMSS_OUT","PRED_EGGS","PRED_ALIVE","PRED_STARVED","PRED_PREDATED","PRED_SENESCED")

    ################# THE WORLD - N, SPACE AND TIME ########################################################
    ########################################################################################################
    World_size=as.integer(switches$World_size)      ###NUMBER OF CELLS SET UNIDIMENSIONALLY

    cells<-1:World_size

    cells<-as.data.frame(cells)

    n_prey=switches$n_prey#500*3                                    ###NUMBER OF PREY
    n_pred=switches$n_pred#281*3  # as.integer(round(n_prey*(1/10),0))     ###NUMBER OF PREDATORS


  seeds<-read.table("seeds.txt",header=T)
  seed_prey=seeds$seed_prey
  seed_pred=seeds$seed_pred


    ####fungi growth array
    fungi<-cells

     ##TO INCLUDE AUTOCORRELATION
    increase<-as.matrix(c(1:round(World_size/2,0)))
    decrease<-as.matrix(c(round(World_size/2,0):1))
    fungi$x<-as.matrix(rbind(increase,decrease))

    fungi$r<-interpol(fungi$x,min_r,max_r)


    fungi$ini<-interpol(fungi$x,min_fungi,max_fungi)
    fungi$K<-interpol(fungi$x,min_K,max_K)     ###########################################################################
    sum(fungi$K)

          ############################# TO REMOVE AUTOCORRELATION AND THE SAME r and ini ACROSS THE WORLD_SIZE CELLS #############################################
          if (autocor==0){
          names(fungi)

          set.seed(seed_prey)
          fungi$aleat<-runif(nrow(fungi))

          names(fungi)

          #[1] "cells" "r"     "ini"   "K" "aleat"

          r_sorted <- fungi[do.call(order,fungi[c(5)]),]  #finally how to sort in R

          r_sorted$orden<-as.numeric(World_size:1)

          r_sorted

          names(r_sorted)
          #[1] "cells" "r"     "ini"   "aleat" "orden"


          new_matrix<-as.data.frame(matrix(nrow=nrow(fungi),ncol=4))


          new_matrix[,1]=r_sorted$orden
          new_matrix[,2]=r_sorted$r
          new_matrix[,3]=r_sorted$ini
          new_matrix[,4]=r_sorted$K


          names(new_matrix)<-c("cells","r","ini","K")

          new_matrix

          fungi<-new_matrix[do.call(order,new_matrix[c(1)]),]

          }

  plot(fungi$cells,fungi$K)

  fungi$cells<-as.integer(fungi$cells)
  fungi$biomass_in<-matrix(nrow=nrow(fungi),ncol=steps)
  fungi$biomass_out<-matrix(nrow=nrow(fungi),ncol=steps)
  fungi$biomass<-matrix(nrow=nrow(fungi),ncol=steps)

  fungi$excess<-matrix(nrow=nrow(fungi),ncol=1,0)

    ##############################################################################################################################################
    ##############################################################################################################################################
    ##############################################################################################################################################
   ########################################################################
######################## TRAITS ########################################
########################################################################

  prey<-prey2
  prey_w_genes<-prey_w_genes2
  pred<-pred2
  pred_w_genes<-pred_w_genes2

  prey$pheno<-round(prey$pheno*interpol2(T,min_T,max_T,1,Q10pheno),0) ##to include Q10 in dev time
  pred$pheno<-round(pred$pheno*interpol2(T,min_T,max_T,1,Q10pheno),0)

    ##############################################################################################################################################
    ##############################################################################################################################################
    ##############################################################################################################################################


      ################# MAIN FUNCTION##################################

  for (i in 1:steps){ #steps   1 step equals 1 day

  fungi<-fungi_func(cells,fungi,i)
    total_biomass<-sum(fungi$biomass[,i])
    total_biomass_out<-sum(fungi$biomass_out[,i])
    TC$BIOMASS[i]<-total_biomass
    TC$BIOMASS_OUT[i]<-total_biomass_out
    TC$PREY_EGGS[i]<-sum(prey$alive==0)
    TC$PREY_ALIVE[i]<-sum(prey$alive==1)
    TC$PREY_STARVED[i]<-sum(prey$alive==2)
    TC$PREY_PREDATED[i]<-sum(prey$alive==3)
    TC$PREY_SENESCED[i]<-sum(prey$alive==6)
    if (predators==1){
    TC$PREY_BMSS_OUT[i]<-sum(pred$food_mass)
    TC$PRED_EGGS[i]<-sum(pred$alive==0)
    TC$PRED_ALIVE[i]<-sum(pred$alive==1)
    TC$PRED_STARVED[i]<-sum(pred$alive==2)
    TC$PRED_PREDATED[i]<-sum(pred$alive==3)
    TC$PRED_SENESCED[i]<-sum(pred$alive==6)
    }


     print("HIGH TEMPERATURE IN C - WITHOUT PREDATORS")
     print(T)
     print("day")
     print(i)
     if (sum(fungi$biomass[,i])==0) stop("fungi_went_extint")

     prey$random<-runif(nrow(prey))
     prey<-prey[do.call(order,prey[c("random")]),]   ##shuffles the order in which each day each animal acts

     if (predators==1){
     pred$random<-runif(nrow(pred))
     pred<-pred[do.call(order,pred[c("random")]),]   ##shuffles the order in which each day each animal acts
     }

     prey<-tune_traits(prey,upper_tank_prey)
     prey<-tune_traits2(prey)

      prey$eaten<-0
     prey$encounters_pred<-0



     if (predators==1){
     pred<-tune_traits(pred,upper_tank_pred)
     pred<-tune_traits2(pred) #this will make only sense when predators feed on each other!!!!!!!!!!!
     pred$eating<-0
     pred$food_mass<-0
     pred$encounters_pred<-0
     pred$encounters_prey<-0
     pred$days_digest<-ifelse(pred$days_digest>0,pred$days_digest-1,0)
     }

     sum_prey_alive<-ifelse(prey$alive==1,1,0)
      if(i>9&sum(sum_prey_alive)==0) {
      write.table(prey,"prey_at_extintion.txt")  ##this is to estimate when prey are all killed (some may have reached adulthood and reproduced, though)
      write.table(i,"i_at_prey_extinction.txt")
      }      ##10 is max phenology for prey


     if (i>1)  ###controls when prey start mattering in the food web - here, one day after simulations start, so fungi have time to grow before depletion
     for (r in 1:nrow(prey)){

      if ((i>=prey$pheno[r])&&(prey$alive[r]==0)) {   ##when pheno (phenology) is reached, the day to be born has arrived and the animal activates
          prey$alive[r]=1
          }


      if (prey$alive[r]==1){

      if (predators==1){
      prey$pasos[r]<-0

      if (prey$search_area_tuned[r]>0){
      for (k in 1:prey$search_area_tuned[r]){ ###search_area_tuned - maximum number of steps to walk in one day (tick)

      if (prey$alive[r]==1){
      prey<-prey_mov(prey,pred,fungi,i,World_size,r)


      in_cell<-for_interaction(pred,prey,fungi,i,r)



      if (is.logical(in_cell)==F){


      in_cell<-predation_prey_move(in_cell,i)

      if(nrow(in_cell)>1){
      prey$alive[r]=in_cell$alive[1]
      prey$date_death[r]=in_cell$date_death[1]
      prey$encounters_pred[r]=prey$encounters_pred[r]+in_cell$encounters_pred[1]
      
      prey$global_pred_encs[r]=prey$global_pred_encs[r]+in_cell$encounters_pred[1]
     

      in_cell<-in_cell[2:nrow(in_cell),] ##Removes the prey from the first row



      for (dd in 1:nrow(in_cell)){
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell$ID[dd]){
      pred$encounters_prey[xx]<-pred$encounters_prey[xx]+in_cell$encounters_prey[dd]
      pred$global_prey_encs[xx]= pred$global_prey_encs[xx]+in_cell$encounters_prey[dd]
      pred$eating[xx]<-in_cell$eating[dd]
      pred$food_mass[xx]<-in_cell$food_mass[dd]
      }
      }
      }
      }
      }
      }
      }###end of moving for prey r in a World with predators
      }


      }else{
      prey$pasos[r]<-0

      if (prey$search_area_tuned[r]>0){
      for (k in 1:prey$search_area_tuned[r]){
      prey<-prey_mov(prey,fungi,i,World_size,r)

      }
      }
      }

      prey<-feed_prey(prey,i,fungi,par_food,eficiencia,upper_tank_prey,r)
      fungi<-fungi_eaten(prey,i,fungi,r,min_fungi,zero_fungi)




    prey<-metab_with_growth(prey,i,assigned,r,deadly_tank,upper_tank_prey)
      }
    }

      if (i>2)##controls when predators start mattering and moving in the food web
      if (predators==1){
      for (t in 1:nrow(pred)){
      if ((i>=pred$pheno[t])&&(pred$alive[t]==0)) {
          pred$alive[t]=1
          }

          if (pred$alive[t]==1&pred$days_digest[t]==0){
          pred<-pred_background(pred,i,t)
          if (pred$alive[t]==5) print(cbind("this one dies from background mortality",t))
          }

           sum_pred_alive<-ifelse(pred$alive==1,1,0)
          if (i>14&sum(sum_pred_alive)==0) stop("predators_went_extint") ##15 is max phenology for predator

      pred$pasos[t]<-0

          if (pred$search_area_tuned[t]>0&pred$alive[t]==1&pred$eating[t]==0&pred$days_digest[t]==0){          ###now, the predators that have not eaten yet, from prey moves, go out to hunt prey
          for (k in 1:pred$search_area_tuned[t]){
          
           if ((pred$days_digest[t]==0)&(pred$alive[t]==1)&(pred$eating[t]==0)){
#
          pred<-pred_mov(prey,pred,fungi,i,World_size,t)
          
          
      in_cell_x1<-as.data.frame(for_interaction_x1(pred,fungi,t))

#
      if (is.logical(in_cell_x1)==F){

      in_cell_x1<-predation_prey_move(in_cell_x1,i)   ##this function is identical as the predator acts as prey passes in_cell_x1 but gets in_cell as in_cell_x1!!!!!

      if(nrow(in_cell_x1)>1){                       ###updates the target predator
      pred$alive[t]=in_cell_x1$alive[1]
      pred$date_death[t]=in_cell_x1$date_death[1]
      pred$encounters_pred[t]=pred$encounters_pred[t]+in_cell_x1$encounters_pred[1]
      pred$global_pred_encs[t]= pred$global_pred_encs[t]+in_cell_x1$encounters_pred[1]

      in_cell_x1<-in_cell_x1[2:nrow(in_cell_x1),] ##Removes the pred[t] from the first row


      for (dd in 1:nrow(in_cell_x1)){     ##updates predators as they may have encounter the predator acting as prey, feed upon it, etc.!!!!!!
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell_x1$ID[dd]){
      pred$encounters_prey[xx]<-pred$encounters_prey[xx]+in_cell_x1$encounters_prey[dd]
      pred$global_prey_encs[xx]= pred$global_prey_encs[xx]+in_cell_x1$encounters_prey[dd]
      pred$eating[xx]<-in_cell_x1$eating[dd]
      pred$food_mass[xx]<-in_cell_x1$food_mass[dd]
      }
      }
      }
      }
      }

      ##the following only happens if the predator is alive and we are going to update the predator status if killed while moving!!!!
      #

      if (pred$alive[t]==1){
      in_cell2<-as.data.frame(for_interaction2_x1(pred,prey,fungi,t))

      if (is.logical(in_cell2)==F){
      in_cell2<-predation_pred_move(in_cell2,i)
      
     


      if(nrow(in_cell2)>1){

      pred$encounters_prey[t]=pred$encounters_prey[t]+in_cell2$encounters_prey[1]
      pred$global_prey_encs[t]=pred$global_prey_encs[t]+pred$encounters_prey[1]
      pred$eating[t]<-in_cell2$eating[1]
      pred$food_mass[t]<-in_cell2$food_mass[1]
  
      #####NEW FOR SPIDERS - UPDATE PREDATORS FROM RETALIATION / SEE ALSO BELOW
      pred$alive[t]=in_cell2$alive[1]
      pred$date_death[t]=in_cell2$date_death[1]
  
      in_cell2<-in_cell2[2:nrow(in_cell2),] ##Removes the pred from the first row

      for (dd in 1:nrow(in_cell2)){         ###updates prey
      for (xx in 1:nrow(prey)){
      if(prey$ID[xx]==in_cell2$ID[dd]&!is.na(charmatch(prey$pred_prey[xx],in_cell2$pred_prey[dd]))&in_cell2$pred_prey[dd]=="prey"){  ###modified on 18_02_2012
      prey$encounters_pred[xx]<-prey$encounters_pred[xx]+in_cell2$encounters_pred[dd]
      prey$global_pred_encs[xx]<-prey$global_pred_encs[xx]+in_cell2$encounters_pred[dd]

      prey$alive[xx]=in_cell2$alive[dd]
      prey$date_death[xx]=in_cell2$date_death[dd]
      }
      }
      }

     ###predators that have potentially acted as prey should be updated for encounters and for status
      for (dd in 1:nrow(in_cell2)){   ###updates predators as if they were prey
      for (xx in 1:nrow(pred)){
      if(pred$ID[xx]==in_cell2$ID[dd]&!is.na(charmatch(pred$pred_prey[xx],in_cell2$pred_prey[dd]))&in_cell2$pred_prey[dd]=="pred"){  ###modified on 18_02_2012
      pred$encounters_pred[xx]<-pred$encounters_pred[xx]+in_cell2$encounters_pred[dd]
      pred$global_pred_encs[xx]<-pred$global_pred_encs[xx]+in_cell2$encounters_pred[dd]
      pred$alive[xx]=in_cell2$alive[dd]
      pred$date_death[xx]=in_cell2$date_death[dd]
      
      ######AND ALSO UPDATE PREY AS IF THEY ARE PREDATORS WHEN RETALIATION OCCURS - INCLUDING ASSIMILATION FROM FEEDING!!!!
      pred$eating[xx]<-in_cell2$eating[dd]
      pred$food_mass[xx]<-in_cell2$food_mass[dd]
      pred<-pred_assim(pred,xx,upper_tank_pred)

      }
      }
      }


      }
      }
      }


          }

          }
          }


          if (pred$alive[t]==1&pred$eating[t]==1){
          pred<-pred_assim(pred,t,upper_tank_pred)
          }

          if (pred$alive[t]==1){   ##new in book chapter, even if it reproduces, it expends energy
          pred<-metab_with_growth(pred,i,assigned,t,deadly_tank,upper_tank_pred)
          }

          }
          }



     if(sum(prey$alive==4)>1){
     all_prey<-repro(TEMP=T,day=i,prey,prey_w_genes,mod_type1=prey_mod_int_1,mod_type2=prey_mod_int_2,
     mod_type3=prey_mod_int_3,mod_type4=prey_mod_int_4,rho=rho_prey)

     if (all_prey$pred_prey[1]=="prey"){
      prey_w_genes<-all_prey[,1:69]
      prey<-all_prey[,70:109]
      names(prey)[1:14]<-c("ID","energy_tank","voracity","speed","body_size","met_rate","growth"
      ,"search_area","assim","pheno","vorQ10","spdQ10","srchQ10","actE_met")
      }
      }



     if(predators==1)
     if(sum(pred$alive==4)>1){
     all_preds<-repro(TEMP=T,day=i,pred,pred_w_genes,mod_type1=pred_mod_int_1,mod_type2=pred_mod_int_2,
      mod_type3=pred_mod_int_3,mod_type4=pred_mod_int_4,rho=rho_pred)

     if (all_preds$pred_prey[1]=="pred"){
      pred_w_genes<-all_preds[,1:69]
      pred<-all_preds[,70:112]
      names(pred)[1:14]<-c("ID","energy_tank","voracity","speed","body_size","met_rate","growth"
      ,"search_area","assim","pheno","vorQ10","spdQ10","srchQ10","actE_met")
      }
      }



     prey<-prey[do.call(order,prey[c("ID")]),] ##sets the original ordering to the array
     if(predators==1)
     pred<-pred[do.call(order,pred[c("ID")]),] ##sets the original ordering to the array


    plot(fungi$cells,fungi$biomass[,i])
  }





  ####outputs
  fungi$output<-ifelse(fungi$biomass[,i]>0,1,0)
  fungi$output

  sum(fungi$output)
  sum(fungi$biomass[,i])
  sum(prey$alive==1)
  mean(prey$critical[prey$alive==1])
  sum(pred$alive==1)
  mean(pred$critical[pred$alive==1])

  pred$alive
  prey$alive
  pred$instar
  prey$instar

  write.table(TC,"high_T_TC_no_preds.txt")   #entrem dades sense substituci a un fitxer nou i amb noms de variables
  write.table(prey,"high_T_prey_no_preds.txt")   #entrem dades sense substituci a un fitxer nou i amb noms de variables
  write.table(fungi,"high_T_fungi_no_preds.txt")   #entrem
  write.table(all_prey,"high_T_prey_genetics_no_preds.txt")



  ###################### INDICES AND PLOTS ############################
  #####################################################################
  #####################################################################
   #####################################################################
    TC<-as.data.frame(matrix(nrow=steps,ncol=6))
    names(TC)<-c("LOW_PREDS","MID_PREDS","HIGH_PREDS","LOW_NO_PREDS","MID_NO_PREDS","HIGH_NO_PREDS")

    A<-read.table("low_T_fungi_w_preds.txt", header=T)
    B<-read.table("medium_T_fungi_w_preds.txt", header=T)
    C<-read.table("high_T_fungi_w_preds.txt", header=T)
    D<-read.table("low_T_fungi_no_preds.txt", header=T)
    E<-read.table("medium_T_fungi_no_preds.txt", header=T)
    F<-read.table("high_T_fungi_no_preds.txt", header=T)

    TC$LOW_PREDS<-colSums(A[,246:(246+steps-1)])
    TC$MID_PREDS<-colSums(B[,246:(246+steps-1)])
    TC$HIGH_PREDS<-colSums(C[,246:(246+steps-1)])
    TC$LOW_NO_PREDS<-colSums(D[,246:(246+steps-1)])
    TC$MID_NO_PREDS<-colSums(E[,246:(246+steps-1)])
    TC$HIGH_NO_PREDS<-colSums(F[,246:(246+steps-1)])

    TC$DAY<-as.integer(1:nrow(TC))


    plot(TC$DAY,TC$LOW_PREDS,,ylim=c(0,max(c(max(TC$LOW_PREDS,na.rm=T),max(TC$MID_PREDS,na.rm=T),max(TC$HIGH_PREDS,na.rm=T)
            ,max(TC$LOW_NO_PREDS,na.rm=T),max(TC$MID_NO_PREDS,na.rm=T),max(TC$HIGH_NO_PREDS,na.rm=T)),na.rm=T)),cex=0.05)
    points(TC$LOW_PREDS, cex=1,  pch = c(15), col = "blue")  ##LOW
    points(TC$MID_PREDS, cex=1,  pch = c(16), col = "green")  ##MID
    points(TC$HIGH_PREDS, cex=1,  pch = c(17), col = "red")  ##HIGH
    points(TC$LOW_NO_PREDS, cex=1,  pch = c(15), col = "cyan")  ##LOW
    points(TC$MID_NO_PREDS, cex=1,  pch = c(16), col = "yellow")  ##MID
    points(TC$HIGH_NO_PREDS, cex=1,  pch = c(17), col = "magenta")  ##HIGH


    lines(TC$LOW_PREDS,lwd = 2, lty = c("solid"), col = "blue")
    lines(TC$MID_PREDS,lwd = 2, lty = c("longdash"), col = "green")
    lines(TC$HIGH_PREDS,lwd = 2, lty = c("longdash"), col = "red")


    lines(TC$LOW_NO_PREDS,lwd = 2, lty = c("solid"), col = "cyan")
    lines(TC$MID_NO_PREDS,lwd = 2, lty = c("longdash"), col = "yellow")
    lines(TC$HIGH_NO_PREDS,lwd = 2, lty = c("longdash"), col = "magenta")



